/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.stream.XMLStreamException;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.LRUCache;
import org.teiid.metadata.index.IndexMetadataStore;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;

public class VDBMetadataFactory {
    public static LRUCache<URL, TransformationMetadata> VDB_CACHE = new LRUCache(10);

    public static TransformationMetadata getVDBMetadata(String vdbFile) {
        try {
            File f = new File(vdbFile);
            return VDBMetadataFactory.getVDBMetadata(f.getName(), f.toURI().toURL(), null);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static TransformationMetadata getVDBMetadata(String vdbName, URL vdbURL, URL udfFile) throws IOException {
        TransformationMetadata vdbmetadata = (TransformationMetadata)VDB_CACHE.get((Object)vdbURL);
        if (vdbmetadata != null) {
            return vdbmetadata;
        }
        try {
            IndexMetadataStore imf = VDBMetadataFactory.loadMetadata(vdbName, vdbURL);
            List methods = null;
            List<FunctionTree> trees = null;
            if (udfFile != null) {
                String schema = FileUtils.getFilenameWithoutExtension((String)udfFile.getPath());
                methods = FunctionMetadataReader.loadFunctionMethods((InputStream)udfFile.openStream());
                trees = Arrays.asList(new FunctionTree(schema, (FunctionMetadataSource)new UDFSource((Collection)methods), true));
            }
            SystemFunctionManager sfm = new SystemFunctionManager();
            vdbmetadata = new TransformationMetadata(null, new CompositeMetadataStore(Arrays.asList(SystemMetadata.getInstance().getSystemStore(), imf)), (Map)imf.getEntriesPlusVisibilities(), sfm.getSystemFunctions(), trees);
            VDB_CACHE.put((Object)vdbURL, (Object)vdbmetadata);
            return vdbmetadata;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static IndexMetadataStore loadMetadata(String vdbName, URL url) throws IOException, MalformedURLException, URISyntaxException {
        String fileName = String.valueOf(vdbName + "-" + url.toExternalForm().hashCode());
        VirtualFile root = VFS.getChild((String)fileName);
        if (!root.exists()) {
            VFS.mountZip((InputStream)url.openStream(), (String)fileName, (VirtualFile)root, (TempFileProvider)TempFileProvider.create((String)"vdbs", (ScheduledExecutorService)Executors.newScheduledThreadPool(2)));
        }
        IndexMetadataStore store = new IndexMetadataStore(root);
        store.load(null, (Collection)SystemMetadata.getInstance().getDataTypes());
        return store;
    }
}

