/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cdk.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class ConnectorHost {
    private ExecutionFactory connector;
    private TranslationUtility util;
    private ExecutionContext executionContext;
    private Object connectionFactory;

    public ConnectorHost(ExecutionFactory connector, Object connectionFactory, String vdbFileName) throws TranslatorException {
        this.initialize(connector, connectionFactory, new TranslationUtility((QueryMetadataInterface)VDBMetadataFactory.getVDBMetadata(vdbFileName)));
    }

    public ConnectorHost(ExecutionFactory connector, Object connectionFactory, TranslationUtility util) throws TranslatorException {
        this.initialize(connector, connectionFactory, util);
    }

    private void initialize(ExecutionFactory connector, Object connectionFactory, TranslationUtility util) throws TranslatorException {
        this.connector = connector;
        this.util = util;
        this.connectionFactory = connectionFactory;
        this.connector.start();
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    public List executeCommand(String query) throws TranslatorException {
        Command command = this.getCommand(query);
        RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
        return this.executeCommand(command, runtimeMetadata, true);
    }

    public List executeCommand(String query, boolean close) throws TranslatorException {
        Command command = this.getCommand(query);
        RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
        return this.executeCommand(command, runtimeMetadata, close);
    }

    public List executeCommand(Command command) throws TranslatorException {
        RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
        return this.executeCommand(command, runtimeMetadata, true);
    }

    private List executeCommand(Command command, RuntimeMetadata runtimeMetadata, boolean close) throws TranslatorException {
        Execution exec = this.connector.createExecution(command, this.executionContext, runtimeMetadata, this.connectionFactory);
        exec.execute();
        List<List> results = this.readResultsFromExecution(exec);
        if (close) {
            exec.close();
        }
        return results;
    }

    public int[] executeBatchedUpdates(String[] updates) throws TranslatorException {
        RuntimeMetadata runtimeMetadata = this.getRuntimeMetadata();
        Command[] commands = new Command[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            commands[i] = this.getCommand(updates[i]);
        }
        return this.executeBatchedUpdates(commands, runtimeMetadata);
    }

    public int[] executeBatchedUpdates(Command[] commands, RuntimeMetadata runtimeMetadata) throws TranslatorException {
        List result = this.executeCommand((Command)new BatchedUpdates(Arrays.asList(commands)), runtimeMetadata, true);
        int[] counts = new int[result.size()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = (Integer)((List)result.get(i)).get(0);
        }
        return counts;
    }

    private List<List> readResultsFromExecution(Execution execution) throws TranslatorException {
        ArrayList<List> results = new ArrayList<List>();
        while (true) {
            try {
                if (execution instanceof ResultSetExecution) {
                    ResultSetExecution rs = (ResultSetExecution)execution;
                    List result = null;
                    while ((result = rs.next()) != null) {
                        results.add(result);
                    }
                } else {
                    UpdateExecution rs = (UpdateExecution)execution;
                    int[] result = rs.getUpdateCounts();
                    for (int i = 0; i < result.length; ++i) {
                        results.add(Arrays.asList(result[i]));
                    }
                }
                break;
            }
            catch (DataNotAvailableException e) {
                if (e.getRetryDelay() <= 0L) continue;
                try {
                    Thread.sleep(e.getRetryDelay());
                }
                catch (InterruptedException e1) {
                    throw new TranslatorException((Throwable)e1);
                }
            }
        }
        return results;
    }

    private RuntimeMetadata getRuntimeMetadata() {
        return this.util.createRuntimeMetadata();
    }

    public Command getCommand(String query) {
        return this.util.parseCommand(query);
    }
}

