/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.UTFDataFormatException;
import org.teiid.internal.core.index.CodeByteStream;
import org.teiid.internal.core.index.IndexBlock;
import org.teiid.internal.core.index.WordEntry;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    @Override
    public boolean isEmpty() {
        return this.offset == 0;
    }

    @Override
    public boolean nextEntry(WordEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, Math.min(prefixLength, this.prevWord.length));
                System.arraycopy(word, 0, temp, Math.min(prefixLength, this.prevWord.length), word.length);
                word = temp;
            }
            if (word.length == 0) {
                return false;
            }
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            for (int i = 0; i < n; ++i) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

