/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.odata4j.core.OEntityKey;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.Expression;
import org.odata4j.expression.ExpressionParser;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.producer.QueryInfo;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.ODataSQLBuilder;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestODataSQLStringVisitor {
    private void te(String in, String expected) {
        CommonExpression expr = ExpressionParser.parse((String)in);
        ODataSQLBuilder visitor = new ODataSQLBuilder((MetadataStore)Mockito.mock(MetadataStore.class), false);
        visitor.visitNode(expr);
        Assert.assertEquals((Object)expected, (Object)visitor.getExpression().toString());
    }

    @Test
    public void testAnd() {
        this.te("a eq 1 and a eq 2", "(a = 1) AND (a = 2)");
        this.te("(x add 4) eq 3", "(x + 4) = 3");
        this.te("((x add y) sub z) mod x eq 0", "MOD(((x + y) - z), x) = 0");
    }

    @Test
    public void testEq() {
        this.te("a eq 1", "a = 1");
        this.te("a eq 4.5f", "a = 4.5");
        this.te("a eq 4.5d", "a = 4.5");
        this.te("a eq null", "a IS NULL");
        this.te("a eq 'foo'", "a = 'foo'");
        this.te("a eq true", "a = TRUE");
        this.te("a eq false", "a = FALSE");
        this.te("a eq time'PT13H20M'", "a = {t'13:20:00'}");
        this.te("a eq datetime'2008-10-13T00:00:00'", "a = {ts'2008-10-13 00:00:00.0'}");
    }

    @Test
    public void testNegate() {
        this.te("- a", "(-1 * a)");
        this.te("-4.5f", "-4.5");
    }

    @Test
    public void testCast() {
        this.te("cast('foo', 'Edm.String')", "CONVERT('foo', string)");
        this.te("cast('foo', 'Edm.Int32')", "CONVERT('foo', integer)");
    }

    @Test
    public void testConcat() {
        this.te("concat('foo', 'bar')", "CONCAT2('foo', 'bar')");
    }

    @Test
    public void testEndsWith() {
        this.te("endswith(x, 'foo')", "ENDSWITH(x, 'foo') = TRUE");
    }

    @Test
    public void testIndexOf() {
        this.te("indexof(x, 'foo')", "LOCATE('foo', x)");
    }

    @Test
    public void testLength() {
        this.te("length(x)", "LENGTH(x)");
    }

    @Test
    public void testOperator() {
        this.te("-1", "-1");
        this.te("not x", "NOT (x)");
        this.te("x mul y", "(x * y)");
        this.te("x div y", "(x / y)");
        this.te("x add y", "(x + y)");
        this.te("x sub y", "(x - y)");
        this.te("x mod y", "MOD(x, y)");
    }

    @Test
    public void testComparisions() {
        this.te("x gt y", "x > y");
        this.te("x lt y", "x < y");
        this.te("x ge y", "x >= y");
        this.te("x le y", "x <= y");
        this.te("x eq y", "x = y");
        this.te("x ne y", "x <> y");
        this.te("x eq null", "x IS NULL");
        this.te("x ne null", "x IS NOT NULL");
    }

    @Test
    public void testStringMethods() {
        this.te("replace(x, y, z)", "REPLACE(x, y, z)");
        this.te("substring(x, 'foo')", "SUBSTRING(x, 'foo')");
        this.te("substring(x, 'foo', 'bar')", "SUBSTRING(x, 'foo', 'bar')");
        this.te("tolower(x)", "LCASE(x)");
        this.te("toupper(x)", "UCASE(x)");
        this.te("trim('x')", "TRIM(' ' FROM 'x')");
        this.te("trim(x) ne 'foo' and toupper(y) eq 'bar'", "(TRIM(' ' FROM x) <> 'foo') AND (UCASE(y) = 'bar')");
        this.te("substringof(x, 'foo')", "LOCATE(x, 'foo', 1) >= 1");
    }

    @Test
    public void testStartsWith() {
        this.te("startswith(x, 'foo')", "LOCATE('foo', x, 1) = 1");
    }

    @Test
    public void testTimeMethods() {
        this.te("year(x)", "YEAR(x)");
        this.te("year(datetime'2008-10-13T00:00:00')", "YEAR({ts'2008-10-13 00:00:00.0'})");
        this.te("month(x)", "MONTH(x)");
        this.te("day(x)", "DAYOFMONTH(x)");
        this.te("hour(x)", "HOUR(x)");
        this.te("minute(x)", "MINUTE(x)");
        this.te("second(x)", "SECOND(x)");
    }

    @Test
    public void testRoundMethods() {
        this.te("round(x)", "ROUND(x, 0)");
        this.te("floor(x)", "FLOOR(x)");
        this.te("ceiling(x)", "CEILING(x)");
    }

    @Test
    public void testOrderby() {
        List expr = ExpressionParser.parseOrderBy((String)"b desc, a");
        ODataSQLBuilder visitor = new ODataSQLBuilder((MetadataStore)Mockito.mock(MetadataStore.class), false);
        visitor.visitNode((OrderByExpression)expr.get(0));
        Assert.assertEquals((Object)"ORDER BY b DESC", (Object)visitor.getOrderBy().toString());
        visitor.visitNode((OrderByExpression)expr.get(1));
        Assert.assertEquals((Object)"ORDER BY b DESC, a", (Object)visitor.getOrderBy().toString());
    }

    private void testSelect(String expected, String tableName, String filter, String select, String orderby, int top, String navProp, OEntityKey entityKey) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
        ODataSQLBuilder visitor = new ODataSQLBuilder((MetadataStore)metadata.getMetadataStore(), false);
        QueryInfo qi = this.buildQueryInfo(filter, select, orderby, top);
        Query query = visitor.selectString(tableName, qi, entityKey, navProp, false);
        Assert.assertEquals((Object)expected, (Object)query.toString());
    }

    private void testSelectCountStar(String expected, String tableName, String filter, String select, String orderby, int top) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        ODataSQLBuilder visitor = new ODataSQLBuilder((MetadataStore)metadata.getMetadataStore(), false);
        QueryInfo qi = this.buildQueryInfo(filter, select, orderby, top);
        Query query = visitor.selectString(tableName, qi, null, null, true);
        Assert.assertEquals((Object)expected, (Object)query.toString());
    }

    private QueryInfo buildQueryInfo(String filter, String select, String orderby, int top) {
        QueryInfo.Builder b = QueryInfo.newBuilder();
        if (filter != null) {
            b.setFilter((BoolCommonExpression)ExpressionParser.parse((String)filter)).build();
        }
        if (select != null) {
            ArrayList<EntitySimpleProperty> esp = new ArrayList<EntitySimpleProperty>();
            StringTokenizer st = new StringTokenizer(select, ",");
            while (st.hasMoreTokens()) {
                esp.add(Expression.simpleProperty((String)st.nextToken().trim()));
            }
            b.setSelect(esp);
        }
        if (orderby != null) {
            b.setOrderBy(ExpressionParser.parseOrderBy((String)orderby));
        }
        if (top != -1) {
            b.setTop(Integer.valueOf(top));
        }
        QueryInfo qi = b.build();
        return qi;
    }

    @Test(expected=NotFoundException.class)
    public void testBadSelect() throws Exception {
        this.testSelect("SELECT e1, x5 FROM pm1.g1", "nw.Shippers", "e1 ne 'foo'", "ShipperID,x5", "ShipperID desc, CompanyName", -1, null, null);
    }

    @Test
    public void testSelectCount() throws Exception {
        this.testSelectCountStar("SELECT COUNT(*) FROM pm1.g1 AS g0 WHERE (g0.e1 >= 10) AND (g0.e1 < 20)", "pm1.g1", "e1 ge 10 and e1 lt 20", "e1,x5", "e1 desc, e2", 10);
    }

    @Test
    public void testSelectQuery() throws Exception {
        this.testSelect("SELECT g0.ShipperID, g0.CompanyName, g0.Phone FROM nw.Shippers AS g0 WHERE (g0.ShipperID >= 10) AND (g0.ShipperID < 20) ORDER BY g0.ShipperID", "nw.Shippers", "ShipperID ge 10 and ShipperID lt 20", null, null, -1, null, null);
        this.testSelect("SELECT g0.CompanyName, g0.Phone, g0.ShipperID FROM nw.Shippers AS g0 WHERE g0.CompanyName <> 'foo' ORDER BY g0.ShipperID", "nw.Shippers", "CompanyName ne 'foo'", "CompanyName,Phone", null, -1, null, null);
        this.testSelect("SELECT g0.CompanyName, g0.Phone, g0.ShipperID FROM nw.Shippers AS g0 WHERE g0.CompanyName <> 'foo' ORDER BY g0.CompanyName DESC, g0.Phone", "nw.Shippers", "CompanyName ne 'foo'", "CompanyName,Phone", "CompanyName desc, Phone", -1, null, null);
        this.testSelect("SELECT g0.ShipperID, g0.CompanyName, g0.Phone FROM nw.Shippers AS g0 ORDER BY g0.ShipperID", "nw.Shippers", null, null, null, 10, null, null);
    }

    @Test
    public void testNavigationalQuery() throws Exception {
        this.testSelect("SELECT g1.EmployeeID, g1.OrderID, g1.CustomerID, g1.ShipVia FROM nw.Customers AS g0 INNER JOIN Orders AS g1 ON g0.CustomerID = g1.CustomerID ORDER BY g1.OrderID", "nw.Customers", null, "EmployeeID", null, -1, "nw.Orders", null);
        this.testSelect("SELECT g2.UnitPrice, g2.OrderID, g2.ProductID FROM (nw.Customers AS g0 INNER JOIN Orders AS g1 ON g0.CustomerID = g1.CustomerID) INNER JOIN OrderDetails AS g2 ON g1.OrderID = g2.OrderID WHERE g1.OrderID = 12 ORDER BY g2.OrderID, g2.ProductID", "nw.Customers", null, "UnitPrice", null, -1, "nw.Orders(12)/nw.OrderDetails", null);
        this.testSelect("SELECT g2.UnitPrice, g2.OrderID, g2.ProductID FROM (nw.Customers AS g0 INNER JOIN Orders AS g1 ON g0.CustomerID = g1.CustomerID) INNER JOIN OrderDetails AS g2 ON g1.OrderID = g2.OrderID WHERE (g0.CustomerID = 33) AND (g1.OrderID = 12) ORDER BY g2.OrderID, g2.ProductID", "nw.Customers", null, "UnitPrice", null, -1, "nw.Orders(12)/nw.OrderDetails", OEntityKey.create((Object[])new Object[]{33}));
    }

    @Test
    public void testEntityKeyQuery() throws Exception {
        this.testSelect("SELECT g0.ShipperID, g0.CompanyName, g0.Phone FROM nw.Shippers AS g0 WHERE g0.ShipperID = 12 ORDER BY g0.ShipperID", "nw.Shippers", null, null, null, -1, null, OEntityKey.create((Object[])new Object[]{12}));
    }

    @Test
    public void testFilterBasedAssosiation() throws Exception {
        this.testSelect("SELECT g0.OrderID, g0.CustomerID, g0.EmployeeID, g0.ShipVia FROM nw.Orders AS g0 INNER JOIN Customers AS g1 ON g0.CustomerID = g1.CustomerID WHERE g1.ContactName = 'Fred' ORDER BY g0.OrderID", "nw.Orders", "Customers/ContactName eq 'Fred'", "OrderID", null, -1, null, null);
        this.testSelect("SELECT g0.ContactName, g0.CustomerID FROM nw.Customers AS g0 INNER JOIN Orders AS g1 ON g0.CustomerID = g1.CustomerID WHERE g1.OrderID = 1 ORDER BY g0.CustomerID", "nw.Customers", "Orders/OrderID eq 1", "ContactName", null, -1, null, null);
    }

    @Test
    public void testOrderByWithCriteria() throws Exception {
        this.testSelect("SELECT g0.ShipperID, g0.CompanyName, g0.Phone FROM nw.Shippers AS g0 WHERE g0.ShipperID = 12 ORDER BY g0.ShipperID DESC", "nw.Shippers", null, null, "ShipperID eq 12 desc", -1, null, null);
    }

    @Test
    public void testAny() throws Exception {
        this.testSelect("SELECT DISTINCT g0.OrderID, g0.CustomerID, g0.EmployeeID, g0.ShipVia FROM nw.Orders AS g0 INNER JOIN OrderDetails AS ol ON g0.OrderID = ol.OrderID WHERE ol.Quantity > 10 ORDER BY g0.OrderID", "nw.Orders", "OrderDetails/any(ol: ol/Quantity gt 10)", "OrderID", null, -1, null, null);
    }

    @Test
    public void testAll() throws Exception {
        this.testSelect("SELECT g0.OrderID, g0.CustomerID, g0.EmployeeID, g0.ShipVia FROM nw.Orders AS g0 WHERE 10 < ALL (SELECT ol.Quantity FROM OrderDetails AS ol WHERE g0.OrderID = ol.OrderID) ORDER BY g0.OrderID", "nw.Orders", "OrderDetails/all(ol: ol/Quantity gt 10)", "OrderID", null, -1, null, null);
    }

    @Test
    public void testMultiEntitykey() throws Exception {
        OEntityKey key = OEntityKey.parse((String)"(11044)");
        this.testSelect("SELECT g1.OrderID, g1.ProductID FROM nw.Orders AS g0 INNER JOIN OrderDetails AS g1 ON g0.OrderID = g1.OrderID WHERE (g0.OrderID = 11044) AND ((g1.OrderID = 11044) AND (g1.ProductID = 62)) ORDER BY g1.OrderID, g1.ProductID", "nw.Orders", null, "OrderID", null, -1, "nw.OrderDetails(OrderID=11044L,ProductID=62L)", key);
    }
}

