/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperty;
import org.odata4j.core.ORelatedEntityLink;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmType;
import org.teiid.core.types.TransformationException;
import org.teiid.odata.LocalClient;

class EntityList
extends ArrayList<OEntity> {
    private int count = 0;
    private String skipToken;
    private String invalidCharacterReplacement;

    public EntityList(String invalidCharacterReplacement) throws SQLException, TransformationException, IOException {
        this.invalidCharacterReplacement = invalidCharacterReplacement;
    }

    void addEntity(ResultSet rs, Map<String, EdmProperty> propertyTypes, Map<String, Boolean> columns, EdmEntitySet entitySet) throws TransformationException, SQLException, IOException {
        this.add((Object)this.getEntity(rs, propertyTypes, columns, entitySet));
    }

    private OEntity getEntity(ResultSet rs, Map<String, EdmProperty> propertyTypes, Map<String, Boolean> columns, EdmEntitySet entitySet) throws TransformationException, SQLException, IOException {
        HashMap<String, OProperty> properties = new HashMap<String, OProperty>();
        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
            Object value = rs.getObject(i + 1);
            String propName = rs.getMetaData().getColumnLabel(i + 1);
            EdmType type = propertyTypes.get(propName).getType();
            OProperty property = LocalClient.buildPropery((String)propName, (EdmType)type, (Object)value, (String)this.invalidCharacterReplacement);
            properties.put(rs.getMetaData().getColumnLabel(i + 1), property);
        }
        OEntityKey key = OEntityKey.infer((EdmEntitySet)entitySet, new ArrayList(properties.values()));
        ArrayList<ORelatedEntityLink> links = new ArrayList<ORelatedEntityLink>();
        for (EdmNavigationProperty navProperty : entitySet.getType().getNavigationProperties()) {
            links.add(OLinks.relatedEntity((String)navProperty.getRelationship().getName(), (String)navProperty.getToRole().getRole(), (String)key.toKeyString()));
        }
        ArrayList projected = new ArrayList();
        for (Map.Entry<String, Boolean> entry : columns.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().booleanValue()) continue;
            projected.add(properties.get(entry.getKey()));
        }
        return OEntities.create((EdmEntitySet)entitySet, (OEntityKey)key, projected, links);
    }

    public int getCount() {
        return this.count;
    }

    public String nextToken() {
        return this.skipToken;
    }

    public void setNextToken(String skipToken) {
        this.skipToken = skipToken;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

