/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.odata4j.core.NamedValue;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmProperty;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.expression.AddExpression;
import org.odata4j.expression.AggregateAllFunction;
import org.odata4j.expression.AggregateAnyFunction;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryLiteral;
import org.odata4j.expression.BoolMethodExpression;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.ByteLiteral;
import org.odata4j.expression.CastExpression;
import org.odata4j.expression.CeilingMethodCallExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.ConcatMethodCallExpression;
import org.odata4j.expression.DateTimeLiteral;
import org.odata4j.expression.DateTimeOffsetLiteral;
import org.odata4j.expression.DayMethodCallExpression;
import org.odata4j.expression.DecimalLiteral;
import org.odata4j.expression.DivExpression;
import org.odata4j.expression.DoubleLiteral;
import org.odata4j.expression.EndsWithMethodCallExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.ExpressionVisitor;
import org.odata4j.expression.FloorMethodCallExpression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.GuidLiteral;
import org.odata4j.expression.HourMethodCallExpression;
import org.odata4j.expression.IndexOfMethodCallExpression;
import org.odata4j.expression.Int64Literal;
import org.odata4j.expression.IntegralLiteral;
import org.odata4j.expression.IsofExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LengthMethodCallExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.MinuteMethodCallExpression;
import org.odata4j.expression.ModExpression;
import org.odata4j.expression.MonthMethodCallExpression;
import org.odata4j.expression.MulExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NegateExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.NullLiteral;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.ReplaceMethodCallExpression;
import org.odata4j.expression.RoundMethodCallExpression;
import org.odata4j.expression.SByteLiteral;
import org.odata4j.expression.SecondMethodCallExpression;
import org.odata4j.expression.SingleLiteral;
import org.odata4j.expression.StartsWithMethodCallExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.SubExpression;
import org.odata4j.expression.SubstringMethodCallExpression;
import org.odata4j.expression.SubstringOfMethodCallExpression;
import org.odata4j.expression.TimeLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.expression.ToUpperMethodCallExpression;
import org.odata4j.expression.TrimMethodCallExpression;
import org.odata4j.expression.YearMethodCallExpression;
import org.odata4j.producer.QueryInfo;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.ODataAggregateAnyBuilder;
import org.teiid.odata.ODataHierarchyVisitor;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.SQLParam;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.translator.odata.ODataTypeManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ODataSQLBuilder
extends ODataHierarchyVisitor {
    private Query query = new Query();
    private OrderBy orderBy = new OrderBy();
    private Criteria criteria;
    private MetadataStore metadata;
    private ArrayList<SQLParam> params = new ArrayList();
    private boolean prepared = true;
    private Stack<Expression> stack = new Stack();
    private GroupSymbol resultEntityGroup;
    private Table resultEntityTable;
    private FromClause fromCluse = null;
    private HashMap<String, GroupSymbol> assosiatedTables = new HashMap();
    private LinkedHashMap<String, Boolean> projectedColumns = new LinkedHashMap();
    private HashMap<String, String> aliasTableNames = new HashMap();
    private AtomicInteger groupCount = new AtomicInteger(1);
    private boolean distinct = false;
    private boolean useLimit = true;

    public ODataSQLBuilder(MetadataStore metadata, boolean prepared) {
        this.metadata = metadata;
        this.prepared = prepared;
    }

    public void setUseLimit(boolean useLimit) {
        this.useLimit = useLimit;
    }

    public Query selectString(String entityName, QueryInfo info, OEntityKey key, String navProperty, boolean countStar) {
        Table entityTable;
        Select select = new Select();
        if (info.select != null) {
            for (EntitySimpleProperty property : info.select) {
                this.projectedColumns.put(property.getPropertyName(), Boolean.TRUE);
            }
        }
        this.resultEntityTable = entityTable = this.findTable(entityName, this.metadata);
        this.resultEntityGroup = new GroupSymbol("g0", entityTable.getFullName());
        this.assosiatedTables.put(entityTable.getFullName(), this.resultEntityGroup);
        this.aliasTableNames.put("g0", entityTable.getFullName());
        if (key != null) {
            this.criteria = this.buildEntityKeyCriteria(entityTable, this.resultEntityGroup, key);
        }
        this.fromCluse = new UnaryFromClause(this.resultEntityGroup);
        if (navProperty != null) {
            String prop = null;
            if (navProperty.startsWith("/")) {
                navProperty = navProperty.substring(1);
            }
            for (String segment : navProperty.split("/")) {
                List refColumns;
                String[] propSplit = segment.split("\\(");
                prop = propSplit[0];
                Column column = this.findColumn(entityTable, prop);
                if (column != null) {
                    this.projectedColumns.clear();
                    this.projectedColumns.put(column.getName(), Boolean.TRUE);
                    continue;
                }
                Table joinTable = this.findTable(prop, this.metadata);
                if (joinTable == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16004, new Object[]{prop}));
                }
                boolean associationFound = false;
                String aliasGroup = "g" + this.groupCount.getAndIncrement();
                for (ForeignKey fk : joinTable.getForeignKeys()) {
                    if (!((Table)fk.getReferenceKey().getParent()).equals((Object)entityTable)) continue;
                    if (this.assosiatedTables.get(joinTable.getFullName()) == null) {
                        refColumns = fk.getReferenceColumns();
                        if (refColumns == null) {
                            refColumns = ODataSQLBuilder.getColumnNames((List)entityTable.getPrimaryKey().getColumns());
                        }
                        this.addJoinTable(aliasGroup, JoinType.JOIN_INNER, joinTable, entityTable, refColumns, ODataSQLBuilder.getColumnNames((List)fk.getColumns()));
                    }
                    associationFound = true;
                    break;
                }
                if (!associationFound) {
                    for (ForeignKey fk : entityTable.getForeignKeys()) {
                        if (!((Table)fk.getReferenceKey().getParent()).equals((Object)joinTable)) continue;
                        if (this.assosiatedTables.get(joinTable.getFullName()) == null) {
                            refColumns = fk.getReferenceColumns();
                            if (refColumns == null) {
                                refColumns = ODataSQLBuilder.getColumnNames((List)joinTable.getPrimaryKey().getColumns());
                            }
                            this.addJoinTable(aliasGroup, JoinType.JOIN_INNER, joinTable, entityTable, ODataSQLBuilder.getColumnNames((List)fk.getColumns()), refColumns);
                        }
                        associationFound = true;
                        break;
                    }
                }
                if (!associationFound) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16003, new Object[]{prop, this.resultEntityTable.getFullName()}));
                }
                entityTable = joinTable;
                this.resultEntityGroup = (GroupSymbol)this.assosiatedTables.get(joinTable.getFullName());
                this.resultEntityTable = entityTable;
                if (propSplit.length <= 1) continue;
                key = OEntityKey.parse((String)("(" + propSplit[1]));
                this.criteria = this.criteria != null ? new CompoundCriteria(0, this.criteria, this.buildEntityKeyCriteria(entityTable, this.resultEntityGroup, key)) : this.buildEntityKeyCriteria(entityTable, this.resultEntityGroup, key);
            }
        }
        if (countStar) {
            AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
            select = new Select(Arrays.asList(aggregateSymbol));
        } else {
            select = this.buildSelectColumns((HashMap)this.projectedColumns, entityTable, this.resultEntityGroup);
        }
        if (info.filter != null) {
            this.visitNode((CommonExpression)info.filter);
        }
        if (!countStar) {
            List orderBy = info.orderBy;
            if (orderBy != null && !orderBy.isEmpty()) {
                for (OrderByExpression expr : info.orderBy) {
                    this.visitNode(expr);
                }
                this.query.setOrderBy(this.orderBy);
            } else {
                KeyRecord record = this.resultEntityTable.getPrimaryKey();
                if (record == null) {
                    record = (KeyRecord)this.resultEntityTable.getUniqueKeys().get(0);
                }
                for (Column column : record.getColumns()) {
                    OrderByExpression expr = org.odata4j.expression.Expression.orderBy((CommonExpression)org.odata4j.expression.Expression.simpleProperty((String)column.getName()), (OrderByExpression.Direction)OrderByExpression.Direction.ASCENDING);
                    this.visitNode(expr);
                }
                this.query.setOrderBy(this.orderBy);
            }
            select.setDistinct(this.distinct);
        }
        From from = new From();
        from.addClause(this.fromCluse);
        this.query.setSelect(select);
        this.query.setFrom(from);
        this.query.setCriteria(this.criteria);
        return this.query;
    }

    private GroupSymbol joinTable(String tableName, String alias, JoinType joinType) {
        Table joinTable = this.findTable(tableName, this.metadata);
        if (joinTable == null) {
            tableName = (String)this.aliasTableNames.get(tableName);
            joinTable = this.findTable(tableName, this.metadata);
        }
        if (joinTable == null && alias != null) {
            tableName = (String)this.aliasTableNames.get(alias);
            joinTable = this.findTable(tableName, this.metadata);
        }
        if (joinTable == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16004, new Object[]{tableName}));
        }
        String joinKey = alias != null ? alias : joinTable.getFullName();
        String aliasGroup = alias == null ? "g" + this.groupCount.getAndIncrement() : alias;
        for (ForeignKey fk : this.resultEntityTable.getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)joinTable)) continue;
            if (this.assosiatedTables.get(joinKey) == null) {
                List refColumns = fk.getReferenceColumns();
                if (refColumns == null) {
                    refColumns = ODataSQLBuilder.getColumnNames((List)joinTable.getPrimaryKey().getColumns());
                }
                this.addJoinTable(aliasGroup, joinType, joinTable, this.resultEntityTable, ODataSQLBuilder.getColumnNames((List)fk.getColumns()), refColumns);
            }
            return (GroupSymbol)this.assosiatedTables.get(alias != null ? aliasGroup : joinTable.getFullName());
        }
        for (ForeignKey fk : joinTable.getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)this.resultEntityTable)) continue;
            if (this.assosiatedTables.get(joinKey) == null) {
                List refColumns = fk.getReferenceColumns();
                if (refColumns == null) {
                    refColumns = ODataSQLBuilder.getColumnNames((List)this.resultEntityTable.getPrimaryKey().getColumns());
                }
                this.addJoinTable(aliasGroup, joinType, joinTable, this.resultEntityTable, refColumns, ODataSQLBuilder.getColumnNames((List)fk.getColumns()));
            }
            return (GroupSymbol)this.assosiatedTables.get(alias != null ? aliasGroup : joinTable.getFullName());
        }
        return null;
    }

    private void addJoinTable(String alias, JoinType joinType, Table joinTable, Table entityTable, List<String> pkColumns, List<String> refColumns) {
        GroupSymbol joinGroup = new GroupSymbol(alias, joinTable.getFullName());
        GroupSymbol entityGroup = (GroupSymbol)this.assosiatedTables.get(entityTable.getFullName());
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        for (int i = 0; i < refColumns.size(); ++i) {
            critList.add(new CompareCriteria((Expression)new ElementSymbol(pkColumns.get(i), entityGroup), 1, (Expression)new ElementSymbol(refColumns.get(i), joinGroup)));
        }
        Criteria crit = (Criteria)critList.get(0);
        for (int i = 1; i < critList.size(); ++i) {
            crit = new CompoundCriteria(0, crit, (Criteria)critList.get(i));
        }
        this.fromCluse = this.fromCluse == null ? new JoinPredicate((FromClause)new UnaryFromClause(entityGroup), (FromClause)new UnaryFromClause(joinGroup), JoinType.JOIN_INNER, crit) : new JoinPredicate(this.fromCluse, (FromClause)new UnaryFromClause(joinGroup), joinType, crit);
        this.assosiatedTables.put(alias, joinGroup);
        this.assosiatedTables.put(joinTable.getFullName(), joinGroup);
        this.aliasTableNames.put(alias, joinTable.getFullName());
    }

    private Criteria buildEntityKeyCriteria(Table table, GroupSymbol entityGroup, OEntityKey entityKey) {
        KeyRecord pk = table.getPrimaryKey();
        if (entityKey.getKeyType() == OEntityKey.KeyType.SINGLE) {
            if (pk.getColumns().size() != 1) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{table.getFullName(), entityKey}));
            }
            Column column = (Column)table.getPrimaryKey().getColumns().get(0);
            return new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityGroup), 1, (Expression)new Constant(entityKey.asSingleValue()));
        }
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        Set keys = entityKey.asComplexValue();
        if (pk.getColumns().size() != keys.size()) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{table.getFullName(), entityKey}));
        }
        for (NamedValue key : keys) {
            Column column = this.findColumn(table, key.getName());
            critList.add(new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityGroup), 1, (Expression)new Constant(key.getValue())));
        }
        return new CompoundCriteria(0, critList);
    }

    private Select buildSelectColumns(HashMap<String, Boolean> selectColumns, Table table, GroupSymbol group) {
        Select select = new Select();
        if (!selectColumns.isEmpty()) {
            for (Column column : table.getPrimaryKey().getColumns()) {
                selectColumns.put(column.getName(), selectColumns.get(column.getName()) != null);
            }
            for (ForeignKey fk : table.getForeignKeys()) {
                for (Column column : fk.getColumns()) {
                    selectColumns.put(column.getName(), selectColumns.get(column.getName()) != null);
                }
            }
            for (String property : selectColumns.keySet()) {
                Column column = this.findColumn(table, property);
                if (column == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16005, new Object[]{property, table.getFullName()}));
                }
                select.addSymbol((Expression)new ElementSymbol(column.getName(), group));
            }
        } else {
            for (Column c : table.getColumns()) {
                select.addSymbol((Expression)new ElementSymbol(c.getName(), group));
                selectColumns.put(c.getName(), Boolean.TRUE);
            }
        }
        return select;
    }

    public void visit(String type) {
        throw new UnsupportedOperationException();
    }

    public void visit(OrderByExpression expr) {
        this.visitNode(expr.getExpression());
        this.visit(expr.getDirection());
    }

    public void visit(OrderByExpression.Direction direction) {
        Expression expr = (Expression)this.stack.pop();
        if (expr instanceof CompareCriteria) {
            expr = ((CompareCriteria)expr).getLeftExpression();
        }
        this.orderBy.addVariable(expr, direction == OrderByExpression.Direction.ASCENDING);
    }

    public void visit(AddExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("+", new Expression[]{lhs, rhs}));
    }

    public void visit(AndExpression expr) {
        this.visitNode((CommonExpression)expr.getLHS());
        this.visitNode((CommonExpression)expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompoundCriteria(0, (Criteria)lhs, (Criteria)rhs);
        this.stack.push(this.criteria);
    }

    public void visit(BooleanLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(16)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(CastExpression expr) {
        this.visitNode(expr.getExpression());
        Constant rhs = new Constant((Object)ODataTypeManager.teiidType((String)expr.getType()));
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("CONVERT", new Expression[]{lhs, rhs}));
    }

    public void visit(ConcatMethodCallExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("CONCAT2", new Expression[]{lhs, rhs}));
    }

    public void visit(DateTimeLiteral expr) {
        Timestamp timestamp = new Timestamp(expr.getValue().toDateTime().getMillis());
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)timestamp, Integer.valueOf(93)));
        } else {
            this.stack.add(new Constant((Object)timestamp));
        }
    }

    public void visit(DateTimeOffsetLiteral expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(DecimalLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(3)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(DivExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("/", new Expression[]{lhs, rhs}));
    }

    public void visit(EndsWithMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        this.visitNode(expr.getValue());
        Expression value = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria((Expression)new Function("ENDSWITH", new Expression[]{target, value}), 1, (Expression)new Constant((Object)Boolean.TRUE));
        this.stack.push(this.criteria);
    }

    public void visit(EntitySimpleProperty expr) {
        String property = expr.getPropertyName();
        if (property.indexOf(47) == -1) {
            this.stack.push(new ElementSymbol(property, this.resultEntityGroup));
            return;
        }
        String[] segments = property.split("/");
        GroupSymbol joinGroup = this.joinTable(segments[0], null, JoinType.JOIN_INNER);
        Table joinTable = this.findTable(joinGroup.getDefinition(), this.metadata);
        Column column = this.findColumn(joinTable, segments[1]);
        if (column == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16005, new Object[]{segments[1], joinTable.getFullName()}));
        }
        this.stack.push(new ElementSymbol(segments[1], joinGroup));
    }

    public void visit(EqExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL ? new IsNullCriteria(lhs) : new CompareCriteria(lhs, 1, rhs);
        this.stack.push(this.criteria);
    }

    public void visit(GeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria(lhs, 6, rhs);
        this.stack.push(this.criteria);
    }

    public void visit(GtExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria(lhs, 4, rhs);
        this.stack.push(this.criteria);
    }

    public void visit(GuidLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue().toString(), Integer.valueOf(12)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue().toString()));
        }
    }

    public void visit(BinaryLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-2)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(ByteLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-6)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(SByteLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-6)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IndexOfMethodCallExpression expr) {
        this.visitNode(expr.getValue());
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        Expression value = (Expression)this.stack.pop();
        this.stack.push(new Function("LOCATE", new Expression[]{value, target}));
    }

    public void visit(SingleLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)Float.valueOf(expr.getValue()), Integer.valueOf(6)));
        } else {
            this.stack.add(new Constant((Object)Float.valueOf(expr.getValue())));
        }
    }

    public void visit(DoubleLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(8)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IntegralLiteral expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(4)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(Int64Literal expr) {
        if (this.prepared) {
            this.stack.add(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(-5)));
        } else {
            this.stack.add(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(IsofExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(LeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria(lhs, 5, rhs);
        this.stack.push(this.criteria);
    }

    public void visit(LengthMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("LENGTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(LtExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria(lhs, 3, rhs);
        this.stack.push(this.criteria);
    }

    public void visit(ModExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("MOD", new Expression[]{lhs, rhs}));
    }

    public void visit(MulExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("*", new Expression[]{lhs, rhs}));
    }

    public void visit(NeExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
            IsNullCriteria crit = new IsNullCriteria(lhs);
            crit.setNegated(true);
            this.criteria = crit;
        } else {
            this.criteria = new CompareCriteria(lhs, 2, rhs);
        }
        this.stack.push(this.criteria);
    }

    public void visit(NegateExpression expr) {
        this.visitNode(expr.getExpression());
        Expression ex = (Expression)this.stack.pop();
        this.stack.push(new Function("*", new Expression[]{new Constant((Object)-1), ex}));
    }

    public void visit(NotExpression expr) {
        this.visitNode(expr.getExpression());
        this.criteria = new NotCriteria((Criteria)new ExpressionCriteria((Expression)this.stack.pop()));
        this.stack.push(this.criteria);
    }

    public void visit(NullLiteral expr) {
        this.stack.push(new Constant(null));
    }

    public void visit(OrExpression expr) {
        this.visitNode((CommonExpression)expr.getLHS());
        this.visitNode((CommonExpression)expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.criteria = new CompoundCriteria(1, (Criteria)lhs, (Criteria)rhs);
        this.stack.push(this.criteria);
    }

    public void visit(ParenExpression expr) {
        this.visitNode(expr.getExpression());
    }

    public void visit(BoolParenExpression expr) {
        this.visitNode(expr.getExpression());
    }

    public void visit(ReplaceMethodCallExpression expr) {
        ArrayList expressions = new ArrayList();
        this.visitNode(expr.getTarget());
        expressions.add(this.stack.pop());
        this.visitNode(expr.getFind());
        expressions.add(this.stack.pop());
        this.visitNode(expr.getReplace());
        expressions.add(this.stack.pop());
        this.stack.push(new Function("REPLACE", expressions.toArray(new Expression[expressions.size()])));
    }

    public void visit(StartsWithMethodCallExpression expr) {
        this.locate((BoolMethodExpression)expr, 1);
    }

    private void locate(BoolMethodExpression expr, int compare) {
        this.visitNode(expr.getTarget());
        Expression target = (Expression)this.stack.pop();
        this.visitNode(expr.getValue());
        Expression value = (Expression)this.stack.pop();
        this.criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{value, target, new Constant((Object)1)}), compare, (Expression)new Constant((Object)1));
        this.stack.push(this.criteria);
    }

    public void visit(StringLiteral expr) {
        if (this.prepared) {
            this.stack.push(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)expr.getValue(), Integer.valueOf(12)));
        } else {
            this.stack.push(new Constant((Object)expr.getValue()));
        }
    }

    public void visit(SubExpression expr) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        this.stack.push(new Function("-", new Expression[]{lhs, rhs}));
    }

    public void visit(SubstringMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        ArrayList expressions = new ArrayList();
        expressions.add(this.stack.pop());
        if (expr.getStart() != null) {
            this.visitNode(expr.getStart());
            expressions.add(this.stack.pop());
        }
        if (expr.getLength() != null) {
            this.visitNode(expr.getLength());
            expressions.add(this.stack.pop());
        }
        this.stack.push(new Function("SUBSTRING", expressions.toArray(new Expression[expressions.size()])));
    }

    public void visit(SubstringOfMethodCallExpression expr) {
        this.locate((BoolMethodExpression)expr, 6);
    }

    public void visit(TimeLiteral expr) {
        Time time = new Time(expr.getValue().toDateTimeToday().getMillis());
        if (this.prepared) {
            this.stack.push(new Reference(this.params.size()));
            this.params.add(new SQLParam((Object)time, Integer.valueOf(92)));
        } else {
            this.stack.push(new Constant((Object)time));
        }
    }

    public void visit(ToLowerMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("LCASE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(ToUpperMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("UCASE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(TrimMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("TRIM", new Expression[]{new Constant((Object)"BOTH"), new Constant((Object)Character.valueOf(' ')), (Expression)this.stack.pop()}));
    }

    public void visit(YearMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("YEAR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(MonthMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("MONTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(DayMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("DAYOFMONTH", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(HourMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("HOUR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(MinuteMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("MINUTE", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(SecondMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("SECOND", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(RoundMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("ROUND", new Expression[]{(Expression)this.stack.pop(), new Constant((Object)0)}));
    }

    public void visit(FloorMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("FLOOR", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(CeilingMethodCallExpression expr) {
        this.visitNode(expr.getTarget());
        this.stack.push(new Function("CEILING", new Expression[]{(Expression)this.stack.pop()}));
    }

    public void visit(AggregateAnyFunction expr) {
        String joinTableName = ((EntitySimpleProperty)expr.getSource()).getPropertyName();
        this.joinTable(joinTableName, expr.getVariable(), JoinType.JOIN_INNER);
        expr.getPredicate().visitThis((ExpressionVisitor)this);
        this.distinct = true;
    }

    public void visit(AggregateAllFunction expr) {
        String tblName = ((EntitySimpleProperty)expr.getSource()).getPropertyName();
        Table joinTable = this.findTable(tblName, this.metadata);
        GroupSymbol joinGroup = new GroupSymbol(expr.getVariable(), tblName);
        if (joinTable == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16009, new Object[]{tblName}));
        }
        ODataAggregateAnyBuilder builder = new ODataAggregateAnyBuilder(expr, this.resultEntityTable, this.resultEntityGroup, joinTable, joinGroup);
        this.criteria = builder.getCriteria();
        this.stack.push(this.criteria);
    }

    private Table findTable(EdmEntitySet entity, MetadataStore store) {
        return this.findTable(entity.getType().getFullyQualifiedTypeName(), store);
    }

    private Table findTable(String tableName, MetadataStore store) {
        Table t;
        Schema s;
        int idx = tableName.indexOf(46);
        if (idx > 0 && (s = store.getSchema(tableName.substring(0, idx))) != null && (t = s.getTable(tableName.substring(idx + 1))) != null) {
            return t;
        }
        for (Schema s2 : store.getSchemaList()) {
            Table t2 = (Table)s2.getTables().get(tableName);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    private Column findColumn(Table table, String propertyName) {
        return table.getColumnByName(propertyName);
    }

    public List<SQLParam> getParameters() {
        return this.params;
    }

    public Table getEntityTable() {
        return this.resultEntityTable;
    }

    Expression getExpression() {
        return (Expression)this.stack.pop();
    }

    OrderBy getOrderBy() {
        return this.orderBy;
    }

    LinkedHashMap<String, Boolean> getProjectedColumns() {
        return this.projectedColumns;
    }

    public Insert insert(EdmEntitySet entitySet, OEntity entity) {
        Table entityTable;
        this.resultEntityTable = entityTable = this.findTable(entitySet, this.metadata);
        this.resultEntityGroup = new GroupSymbol(entityTable.getFullName());
        ArrayList<Reference> values = new ArrayList<Reference>();
        Insert insert = new Insert();
        insert.setGroup(this.resultEntityGroup);
        int i = 0;
        for (OProperty prop : entity.getProperties()) {
            EdmProperty edmProp = entitySet.getType().findProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            insert.addVariable(new ElementSymbol(column.getName(), this.resultEntityGroup));
            values.add(new Reference(i++));
            this.params.add(this.asParam(prop, edmProp));
        }
        insert.setValues(values);
        return insert;
    }

    public OEntityKey buildEntityKey(EdmEntitySet entitySet, OEntity entity, Map<String, Object> generatedKeys) {
        Table entityTable = this.findTable(entitySet, this.metadata);
        KeyRecord pk = entityTable.getPrimaryKey();
        ArrayList<OProperty> props = new ArrayList<OProperty>();
        for (Column c : pk.getColumns()) {
            OProperty prop = null;
            try {
                prop = entity.getProperty(c.getName());
            }
            catch (Exception e) {
                Object value = generatedKeys.get(c.getName());
                if (value == null) {
                    if (pk.getColumns().size() == 1 && generatedKeys.size() == 1) {
                        value = generatedKeys.values().iterator().next();
                    }
                    if (value == null) {
                        throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16016, new Object[]{entity.getEntitySetName()}));
                    }
                }
                prop = OProperties.simple((String)c.getName(), (Object)value);
            }
            props.add(prop);
        }
        return OEntityKey.infer((EdmEntitySet)entitySet, props);
    }

    public Delete delete(EdmEntitySet entitySet, OEntityKey entityKey) {
        Table entityTable;
        this.resultEntityTable = entityTable = this.findTable(entitySet, this.metadata);
        this.resultEntityGroup = new GroupSymbol(entityTable.getFullName());
        Delete delete = new Delete();
        delete.setGroup(this.resultEntityGroup);
        delete.setCriteria(this.buildEntityKeyCriteria(entityTable, this.resultEntityGroup, entityKey));
        return delete;
    }

    public Update update(EdmEntitySet entitySet, OEntity entity) {
        Table entityTable;
        this.resultEntityTable = entityTable = this.findTable(entitySet, this.metadata);
        this.resultEntityGroup = new GroupSymbol(entityTable.getFullName());
        Update update = new Update();
        update.setGroup(this.resultEntityGroup);
        update.setCriteria(this.buildEntityKeyCriteria(entityTable, this.resultEntityGroup, entity.getEntityKey()));
        int i = 0;
        for (OProperty prop : entity.getProperties()) {
            EdmProperty edmProp = entitySet.getType().findProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            boolean add = true;
            for (Column c : entityTable.getPrimaryKey().getColumns()) {
                if (!c.getName().equals(column.getName())) continue;
                add = false;
            }
            if (!add) continue;
            update.addChange(new ElementSymbol(column.getName(), this.resultEntityGroup), (Expression)new Reference(i++));
            this.params.add(this.asParam(prop, edmProp));
        }
        return update;
    }

    private SQLParam asParam(OProperty<?> prop, EdmProperty edmProp) {
        return new SQLParam(ODataTypeManager.convertToTeiidRuntimeType((Object)prop.getValue()), Integer.valueOf(JDBCSQLTypeInfo.getSQLType((String)ODataTypeManager.teiidType((String)edmProp.getType().getFullyQualifiedTypeName()))));
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }
}

