/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.util.ArrayList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.consumer.AbstractConsumerEntityPayloadRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OModifyRequest;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.format.Entry;
import org.odata4j.internal.EntitySegment;

public class ConsumerEntityModificationRequest<T>
extends AbstractConsumerEntityPayloadRequest
implements OModifyRequest<T> {
    private final T updateRoot;
    private final ODataClient client;
    private final List<EntitySegment> segments = new ArrayList<EntitySegment>();
    private EdmEntitySet entitySet;
    private String ifMatch;

    public ConsumerEntityModificationRequest(T updateRoot, ODataClient client, String serviceRootUri, EdmDataServices metadata, String entitySetName, OEntityKey key, String ifMatch) {
        super(entitySetName, serviceRootUri, metadata);
        this.updateRoot = updateRoot;
        this.client = client;
        this.ifMatch = ifMatch;
        this.segments.add(new EntitySegment(entitySetName, key));
        this.entitySet = metadata.getEdmEntitySet(entitySetName);
    }

    @Override
    public OModifyRequest<T> nav(String navProperty, OEntityKey key) {
        this.segments.add(new EntitySegment(navProperty, key));
        this.entitySet = this.metadata.getEdmEntitySet(this.entitySet.getType().findNavigationProperty(navProperty).getToRole().getType());
        return this;
    }

    @Override
    public void execute() throws ODataProducerException {
        ODataClientRequest request;
        List requestProps = this.props;
        if (this.updateRoot != null) {
            OEntity updateRootEntity = (OEntity)this.updateRoot;
            requestProps = Enumerable.create(updateRootEntity.getProperties()).toList();
            for (final OProperty prop : this.props) {
                OProperty requestProp = (OProperty)Enumerable.create((Iterable)requestProps).firstOrNull(new Predicate1<OProperty<?>>(){

                    public boolean apply(OProperty<?> input) {
                        return input.getName().equals(prop.getName());
                    }
                });
                requestProps.remove(requestProp);
                requestProps.add(prop);
            }
        }
        OEntityKey entityKey = ((EntitySegment)Enumerable.create(this.segments).last()).key;
        Entry entry = this.client.createRequestEntry(this.entitySet, entityKey, requestProps, this.links);
        String path = Enumerable.create(this.segments).join("/");
        ODataClientRequest oDataClientRequest = request = this.updateRoot != null ? ODataClientRequest.put(this.serviceRootUri + path, entry) : ODataClientRequest.merge(this.serviceRootUri + path, entry);
        if (this.ifMatch != null) {
            request.header("If-Match", this.ifMatch);
        }
        this.client.updateEntity(request);
    }

    @Override
    public OModifyRequest<T> properties(OProperty<?> ... props) {
        return super.properties(this, props);
    }

    @Override
    public OModifyRequest<T> properties(Iterable<OProperty<?>> props) {
        return super.properties(this, props);
    }

    @Override
    public OModifyRequest<T> link(String navProperty, OEntity target) {
        return super.link(this, navProperty, target);
    }

    @Override
    public OModifyRequest<T> link(String navProperty, OEntityKey targetKey) {
        return super.link(this, navProperty, targetKey);
    }

    @Override
    public OModifyRequest<T> ifMatch(String precondition) {
        this.ifMatch = precondition;
        return this;
    }
}

