/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.format.FormatParser;
import org.odata4j.format.Settings;
import org.odata4j.format.json.JsonCollectionFormatParser;
import org.odata4j.format.json.JsonFormatParser;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.format.json.JsonTypeConverter;

public class JsonComplexObjectFormatParser
extends JsonFormatParser
implements FormatParser<OComplexObject> {
    private static final boolean DUMP = false;
    private EdmComplexType returnType = null;

    private static void dump(String msg) {
    }

    public JsonComplexObjectFormatParser(Settings s) {
        super(s);
        this.returnType = (EdmComplexType)(s == null ? null : s.parseType);
    }

    public JsonComplexObjectFormatParser(EdmComplexType type) {
        super(null);
        this.returnType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OComplexObject parse(Reader reader) {
        JsonStreamReaderFactory.JsonStreamReader jsr = JsonStreamReaderFactory.createJsonStreamReader(reader);
        try {
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureStartObject(jsr.nextEvent());
                this.ensureNext(jsr);
                this.ensureStartProperty(jsr.nextEvent(), "d");
                this.ensureNext(jsr);
                this.ensureStartObject(jsr.nextEvent());
                this.ensureNext(jsr);
                this.ensureStartProperty(jsr.nextEvent());
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureStartObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureStartProperty(jsr.nextEvent(), "results");
                }
            }
            OComplexObject o = this.parseSingleObject(jsr);
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureEndProperty(jsr.nextEvent());
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureEndObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureEndProperty(jsr.nextEvent());
                }
                this.ensureNext(jsr);
                this.ensureEndObject(jsr.nextEvent());
            }
            OComplexObject oComplexObject = o;
            return oComplexObject;
        }
        finally {
            jsr.close();
        }
    }

    public OComplexObject parseSingleObject(JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonComplexObjectFormatParser.dump("json parseSingleObject: " + this.returnType.getFullyQualifiedTypeName());
        this.ensureNext(jsr);
        OComplexObject result = null;
        JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
        if (event.isStartObject()) {
            ArrayList props = new ArrayList();
            result = this.eatProps(props, jsr);
        }
        JsonComplexObjectFormatParser.dump("json done parseSingleObject: " + this.returnType.getFullyQualifiedTypeName());
        return result;
    }

    public OComplexObject parseSingleObject(JsonStreamReaderFactory.JsonStreamReader jsr, JsonStreamReaderFactory.JsonStreamReader.JsonEvent startPropertyEvent) {
        ArrayList props = new ArrayList();
        this.addProperty(props, startPropertyEvent.asStartProperty().getName(), jsr);
        return this.eatProps(props, jsr);
    }

    private OComplexObject eatProps(List<OProperty<?>> props, JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonComplexObjectFormatParser.dump("json eatProps: " + this.returnType.getFullyQualifiedTypeName());
        this.ensureNext(jsr);
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
            if (event.isStartProperty()) {
                this.addProperty(props, event.asStartProperty().getName(), jsr);
                continue;
            }
            if (event.isEndObject()) break;
            throw new JsonStreamReaderFactory.JsonParseException("unexpected parse event: " + event.toString());
        }
        JsonComplexObjectFormatParser.dump("json done eatProps: " + this.returnType.getFullyQualifiedTypeName());
        return OComplexObjects.create(this.returnType, props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addProperty(List<OProperty<?>> props, String name, JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
        JsonComplexObjectFormatParser.dump("json addProperty: " + name);
        if (event.isEndProperty()) {
            EdmProperty ep = this.returnType.findProperty(name);
            if (ep == null) {
                throw new IllegalArgumentException("unknown property " + name + " for " + this.returnType.getFullyQualifiedTypeName());
            }
            if (!ep.getType().isSimple()) {
                if (event.asEndProperty().getValue() != null) throw new UnsupportedOperationException("Only simple properties supported");
                props.add(OProperties.complex(name, (EdmComplexType)ep.getType(), null));
            } else {
                props.add(JsonTypeConverter.parse(name, (EdmSimpleType)ep.getType(), event.asEndProperty().getValue(), event.asEndProperty().getValueTokenType()));
            }
        } else {
            if (!event.isStartObject()) throw new JsonStreamReaderFactory.JsonParseException("expecting endproperty or startobject, got: " + event.toString());
            this.parseEmbedded(name, event, jsr, props);
        }
        JsonComplexObjectFormatParser.dump("json done addProperty: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseEmbedded(String propName, JsonStreamReaderFactory.JsonStreamReader.JsonEvent event, JsonStreamReaderFactory.JsonStreamReader jsr, List<OProperty<?>> props) {
        JsonComplexObjectFormatParser.dump("json parseEmbedded " + propName);
        this.ensureStartObject(event);
        event = jsr.nextEvent();
        this.ensureStartProperty(event);
        JsonStreamReaderFactory.JsonStreamReader.JsonStartPropertyEvent startProp = event.asStartProperty();
        EdmProperty eprop = this.returnType.findProperty(propName);
        if ("results".equals(startProp.getName())) {
            JsonComplexObjectFormatParser.dump("json embeddedCollection" + (eprop != null ? eprop.getName() : "null"));
            if (eprop == null || eprop.getCollectionKind() == EdmProperty.CollectionKind.NONE) {
                throw new RuntimeException("unhandled property: " + startProp.getName());
            }
            EdmCollectionType collectionType = new EdmCollectionType(eprop.getCollectionKind(), eprop.getType());
            JsonCollectionFormatParser cfp = new JsonCollectionFormatParser(collectionType, this.metadata);
            OCollection<? extends OObject> collection = cfp.parseCollection(jsr);
            this.ensureEndArray(jsr.previousEvent());
            props.add(OProperties.collection(propName, collectionType, collection));
            this.ensureEndProperty(jsr.nextEvent());
            this.ensureEndObject(jsr.nextEvent());
            this.ensureEndProperty(jsr.nextEvent());
            JsonComplexObjectFormatParser.dump("json done embeddedCollection" + (eprop != null ? eprop.getName() : "null"));
        } else if (eprop.getType() instanceof EdmComplexType) {
            EdmComplexType outerType = this.returnType;
            this.returnType = (EdmComplexType)eprop.getType();
            JsonComplexObjectFormatParser.dump("json embedded complex" + this.returnType.getFullyQualifiedTypeName());
            try {
                OComplexObject o = this.parseSingleObject(jsr, startProp);
                this.ensureEndObject(jsr.previousEvent());
                props.add(OProperties.complex(propName, this.returnType, o.getProperties()));
                this.ensureEndProperty(jsr.nextEvent());
            }
            finally {
                this.returnType = outerType;
            }
            JsonComplexObjectFormatParser.dump("json done embedded complex" + this.returnType.getFullyQualifiedTypeName());
        } else {
            throw new RuntimeException("unhandled property: " + startProp.getName());
        }
        JsonComplexObjectFormatParser.dump("json done parseEmbedded " + propName);
    }
}

