/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.util.ArrayList;
import org.odata4j.format.xml.AtomCollectionInfo;
import org.odata4j.format.xml.AtomWorkspaceInfo;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;

public class AtomServiceDocumentFormatParser
extends XmlFormatParser {
    public static Iterable<AtomWorkspaceInfo> parseWorkspaces(XMLEventReader2 reader) {
        ArrayList<AtomWorkspaceInfo> workspaces = new ArrayList<AtomWorkspaceInfo>();
        String baseUrl = null;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (AtomServiceDocumentFormatParser.isStartElement(event, APP_SERVICE)) {
                baseUrl = event.asStartElement().getAttributeByName(XML_BASE).getValue();
                continue;
            }
            if (AtomServiceDocumentFormatParser.isStartElement(event, APP_WORKSPACE)) {
                workspaces.add(AtomServiceDocumentFormatParser.parseWorkspace(baseUrl, reader, event.asStartElement()));
                continue;
            }
            if (!AtomServiceDocumentFormatParser.isEndElement(event, APP_SERVICE)) continue;
            return workspaces;
        }
        throw new IllegalStateException("Closing service tag not found");
    }

    private static AtomWorkspaceInfo parseWorkspace(String baseUrl, XMLEventReader2 reader, StartElement2 startElement) {
        String title = null;
        ArrayList<AtomCollectionInfo> collections = new ArrayList<AtomCollectionInfo>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (AtomServiceDocumentFormatParser.isStartElement(event, ATOM_TITLE)) {
                title = reader.getElementText();
                continue;
            }
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return new AtomWorkspaceInfo(title, collections);
            }
            if (!AtomServiceDocumentFormatParser.isStartElement(event, APP_COLLECTION)) continue;
            collections.add(AtomServiceDocumentFormatParser.parseCollection(baseUrl, reader, event.asStartElement()));
        }
        return new AtomWorkspaceInfo(title, collections);
    }

    private static AtomCollectionInfo parseCollection(String baseUrl, XMLEventReader2 reader, StartElement2 startElement) {
        String href = AtomServiceDocumentFormatParser.getAttributeValueIfExists(startElement, "href");
        String url = AtomServiceDocumentFormatParser.urlCombine(baseUrl, href);
        String title = null;
        String accept = null;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                return new AtomCollectionInfo(href, url, title, accept);
            }
            if (AtomServiceDocumentFormatParser.isStartElement(event, ATOM_TITLE)) {
                title = reader.getElementText();
                continue;
            }
            if (!AtomServiceDocumentFormatParser.isStartElement(event, APP_ACCEPT)) continue;
            accept = reader.getElementText();
        }
        return new AtomCollectionInfo(href, url, title, accept);
    }
}

