/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataHttpMethod;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntity;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OFunctionParameters;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.exceptions.MethodNotAllowedException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CollectionResponse;
import org.odata4j.producer.ComplexObjectResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataContextImpl;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.PropertyResponse;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.SimpleResponse;
import org.odata4j.producer.resources.BaseResource;

public class FunctionResource
extends BaseResource {
    public static Response callFunction(ODataHttpMethod callingMethod, HttpHeaders httpHeaders, UriInfo uriInfo, SecurityContext securityContext, ODataProducer producer, String functionName, String format, String callback, QueryInfo queryInfo) throws Exception {
        FormatWriter<BaseResponse> fwBase;
        FormatWriter<BaseResponse> fw;
        ODataHttpMethod expectedHttpMethod;
        EdmFunctionImport function = producer.getMetadata().findEdmFunctionImport(functionName);
        if (function == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String expectedHttpMethodString = function.getHttpMethod();
        if (expectedHttpMethodString != null && !"".equals(expectedHttpMethodString) && (expectedHttpMethod = ODataHttpMethod.fromString(expectedHttpMethodString)) != callingMethod) {
            throw new MethodNotAllowedException();
        }
        BaseResponse response = producer.callFunction(ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).aspect(producer).build(), function, FunctionResource.getFunctionParameters(function, queryInfo.customOptions), queryInfo);
        if (response == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        ODataVersion version = ODataConstants.DATA_SERVICE_VERSION;
        StringWriter sw = new StringWriter();
        if (response instanceof ComplexObjectResponse) {
            fw = FormatWriterFactory.getFormatWriter(ComplexObjectResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)response);
            fwBase = fw;
        } else if (response instanceof CollectionResponse) {
            CollectionResponse collectionResponse = (CollectionResponse)response;
            if (collectionResponse.getCollection().getType() instanceof EdmEntityType) {
                FormatWriter<EntitiesResponse> fw2 = FormatWriterFactory.getFormatWriter(EntitiesResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
                ArrayList<OEntity> entities = new ArrayList<OEntity>(collectionResponse.getCollection().size());
                Iterator iter = collectionResponse.getCollection().iterator();
                while (iter.hasNext()) {
                    entities.add((OEntity)iter.next());
                }
                EntitiesResponse er = Responses.entities(entities, collectionResponse.getEntitySet(), collectionResponse.getInlineCount(), collectionResponse.getSkipToken());
                fw2.write(uriInfo, sw, er);
                fwBase = fw2;
            } else {
                FormatWriter<CollectionResponse> fw3 = FormatWriterFactory.getFormatWriter(CollectionResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
                fw3.write(uriInfo, sw, collectionResponse);
                fwBase = fw3;
            }
        } else if (response instanceof EntitiesResponse) {
            fw = FormatWriterFactory.getFormatWriter(EntitiesResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)((Object)((EntitiesResponse)response)));
            fwBase = fw;
        } else if (response instanceof PropertyResponse) {
            fw = FormatWriterFactory.getFormatWriter(PropertyResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)((Object)((PropertyResponse)response)));
            fwBase = fw;
        } else if (response instanceof SimpleResponse) {
            fw = FormatWriterFactory.getFormatWriter(SimpleResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)((Object)((SimpleResponse)response)));
            fwBase = fw;
        } else if (response instanceof EntityResponse) {
            fw = FormatWriterFactory.getFormatWriter(EntityResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)((Object)((EntityResponse)response)));
            fwBase = fw;
        } else {
            throw new NotImplementedException("Unknown BaseResponse type: " + response.getClass().getName());
        }
        String entity = sw.toString();
        return Response.ok((Object)entity, (String)fwBase.getContentType()).header("DataServiceVersion", (Object)version.asString).build();
    }

    private static Map<String, OFunctionParameter> getFunctionParameters(EdmFunctionImport function, Map<String, String> opts) {
        HashMap<String, OFunctionParameter> m = new HashMap<String, OFunctionParameter>();
        for (EdmFunctionParameter p : function.getParameters()) {
            String val = opts.get(p.getName());
            m.put(p.getName(), val == null ? null : OFunctionParameters.parse(p.getName(), p.getType(), val));
        }
        return m;
    }
}

