/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ImmutableList<T>
implements List<T>,
RandomAccess {
    private final List<T> values;
    private static final ImmutableList<Object> EMPTY = new ImmutableList(Collections.emptyList());

    private ImmutableList(List<T> values) {
        this.values = values;
    }

    public static <T> ImmutableList<T> create(T ... values) {
        if (values.length == 0) {
            return EMPTY;
        }
        return new ImmutableList<T>(Arrays.asList(values));
    }

    public static <T> ImmutableList<T> copyOf(List<T> values) {
        if (values == null) {
            return EMPTY;
        }
        if (values instanceof ImmutableList) {
            return (ImmutableList)values;
        }
        return ImmutableList.create(values.toArray());
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ImmutableList && ((ImmutableList)obj).values.equals(this.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <TArray> TArray[] toArray(TArray[] a) {
        return this.values.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.values.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.values.subList(fromIndex, toIndex);
    }

    private static UnsupportedOperationException newModificationUnsupported() {
        return new UnsupportedOperationException(ImmutableList.class.getSimpleName() + " cannot be modified");
    }

    @Override
    public void clear() {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public T set(int paramInt, T paramE) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public void add(int paramInt, T paramE) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public T remove(int paramInt) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean add(T paramE) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean remove(Object paramObject) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean addAll(Collection<? extends T> paramCollection) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean addAll(int paramInt, Collection<? extends T> paramCollection) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean removeAll(Collection<?> paramCollection) {
        throw ImmutableList.newModificationUnsupported();
    }

    @Override
    public boolean retainAll(Collection<?> paramCollection) {
        throw ImmutableList.newModificationUnsupported();
    }
}

