/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.odata4j.format.json.JsonStreamReaderFactory;

class JsonStreamTokenizerImpl
implements JsonStreamReaderFactory.JsonStreamTokenizer {
    private Reader reader;
    private JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken token;
    private NumberFormat nf = DecimalFormat.getNumberInstance(Locale.US);
    private int pushedBack = -1;

    JsonStreamTokenizerImpl(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
        this.move();
    }

    @Override
    public boolean hasNext() {
        return this.token != null;
    }

    @Override
    public JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken nextToken() {
        JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken cur = this.token;
        this.move();
        return cur;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            throw new JsonStreamReaderFactory.JsonParseException(ioe);
        }
    }

    private void move() {
        int i;
        this.token = null;
        StringBuilder buffer = new StringBuilder();
        boolean quote = false;
        TokenizerState state = TokenizerState.DEFAULT;
        while (this.token == null && (i = this.next()) != -1) {
            char c = (char)i;
            if (state == TokenizerState.DEFAULT) {
                if ('{' == c) {
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.LEFT_CURLY_BRACKET);
                    continue;
                }
                if ('}' == c) {
                    if (this.hasConstantParsed(buffer)) {
                        this.pushBack(i);
                        continue;
                    }
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.RIGHT_CURLY_BRACKET);
                    continue;
                }
                if ('[' == c) {
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.LEFT_BRACKET);
                    continue;
                }
                if (']' == c) {
                    if (this.hasConstantParsed(buffer)) {
                        this.pushBack(i);
                        continue;
                    }
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.RIGHT_BRACKET);
                    continue;
                }
                if (':' == c) {
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.COLON);
                    continue;
                }
                if (',' == c) {
                    if (this.hasConstantParsed(buffer)) {
                        this.pushBack(i);
                        continue;
                    }
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.COMMA);
                    continue;
                }
                if ('\"' == c) {
                    if (buffer.length() > 0) {
                        throw new JsonStreamReaderFactory.JsonParseException("no JSON format");
                    }
                    state = TokenizerState.STRING;
                    continue;
                }
                if ('-' == c || Character.isDigit(c)) {
                    buffer.append(c);
                    state = TokenizerState.NUMBER;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    this.hasConstantParsed(buffer);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (state == TokenizerState.STRING) {
                if (quote) {
                    if ('b' == c) {
                        buffer.append('\b');
                    } else if ('f' == c) {
                        buffer.append('\f');
                    } else if ('n' == c) {
                        buffer.append('\n');
                    } else if ('r' == c) {
                        buffer.append('\r');
                    } else if ('t' == c) {
                        buffer.append('\t');
                    } else if ('/' == c) {
                        buffer.append('/');
                    } else if ('\\' == c) {
                        buffer.append('\\');
                    } else if ('\"' == c) {
                        buffer.append('\"');
                    } else if ('u' == c) {
                        buffer.append((char)Integer.parseInt(new String(this.next(4)), 16));
                    } else {
                        throw new JsonStreamReaderFactory.JsonParseException("illegal escaped character " + c);
                    }
                    quote = false;
                    continue;
                }
                if ('\\' == c) {
                    quote = true;
                    continue;
                }
                if ('\"' == c) {
                    this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.STRING, buffer.toString());
                    continue;
                }
                buffer.append(c);
                quote = false;
                continue;
            }
            if ('-' == c || Character.isDigit(c) || 'E' == c || 'e' == c || '+' == c || '.' == c) {
                buffer.append(c);
                continue;
            }
            this.pushBack(i);
            this.checkNumberFormat(buffer);
            this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.NUMBER, buffer.toString());
        }
        if (state == TokenizerState.NUMBER) {
            this.checkNumberFormat(buffer);
            this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.NUMBER, buffer.toString());
        }
    }

    private Number checkNumberFormat(StringBuilder memory) {
        try {
            return this.nf.parse(memory.toString());
        }
        catch (Exception nfe) {
            throw new JsonStreamReaderFactory.JsonParseException("", nfe);
        }
    }

    private boolean hasConstantParsed(StringBuilder memory) {
        if (this.isTrue(memory)) {
            this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.TRUE, "true");
        } else if (this.isFalse(memory)) {
            this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.FALSE, "false");
        } else if (this.isNull(memory)) {
            this.token = new JsonStreamReaderFactory.JsonStreamTokenizer.JsonToken(JsonStreamReaderFactory.JsonStreamTokenizer.JsonTokenType.NULL, "null");
        }
        return this.token != null;
    }

    private void pushBack(int c) {
        if (this.pushedBack != -1) {
            throw new IllegalStateException("can push back only one character");
        }
        this.pushedBack = c;
    }

    private char[] next(int count) {
        char[] ret = new char[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = (char)this.next();
        }
        return ret;
    }

    private int next() {
        if (this.pushedBack != -1) {
            int ret = this.pushedBack;
            this.pushedBack = -1;
            return ret;
        }
        try {
            return this.reader.read();
        }
        catch (IOException ioe) {
            throw new JsonStreamReaderFactory.JsonParseException(ioe);
        }
    }

    private boolean isTrue(StringBuilder str) {
        return str.length() == 4 && str.charAt(0) == 't' && str.charAt(1) == 'r' && str.charAt(2) == 'u' && str.charAt(3) == 'e';
    }

    private boolean isFalse(StringBuilder str) {
        return str.length() == 5 && str.charAt(0) == 'f' && str.charAt(1) == 'a' && str.charAt(2) == 'l' && str.charAt(3) == 's' && str.charAt(4) == 'e';
    }

    private boolean isNull(StringBuilder str) {
        return str.length() == 4 && str.charAt(0) == 'n' && str.charAt(1) == 'u' && str.charAt(2) == 'l' && str.charAt(3) == 'l';
    }

    static enum TokenizerState {
        DEFAULT,
        STRING,
        NUMBER;

    }
}

