/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.ORelatedEntityLink;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.translator.odata.ODataTypeManager;

class EntityList
extends ArrayList<OEntity> {
    private int count = 0;
    private int batchSize;
    private int skipSize;

    public EntityList(Map<String, Boolean> columns, EdmEntitySet entitySet, ResultSet rs, int skipSize, int batchSize, boolean getCount) throws SQLException, TransformationException, IOException {
        this.batchSize = batchSize;
        this.skipSize = skipSize;
        if (columns == null) {
            columns = new HashMap<String, Boolean>();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                columns.put(rs.getMetaData().getColumnLabel(i + 1), Boolean.TRUE);
            }
        }
        HashMap<String, EdmProperty> propertyTypes = new HashMap<String, EdmProperty>();
        EdmEntityType entityType = entitySet.getType();
        for (EdmProperty prop : entityType.getProperties()) {
            propertyTypes.put(prop.getName(), prop);
        }
        int size = batchSize;
        if (getCount && rs.last()) {
            this.count = rs.getRow();
        }
        for (int i = 1; i <= size && rs.absolute(i); ++i) {
            this.add((Object)this.getEntity(rs, propertyTypes, columns, entitySet));
        }
    }

    private OProperty<?> buildPropery(String propName, EdmSimpleType expectedType, Object value) throws TransformationException, SQLException, IOException {
        Class targetType;
        if (value == null) {
            return OProperties.null_((String)propName, (EdmSimpleType)expectedType);
        }
        Class sourceType = DataTypeManager.getRuntimeType(value.getClass());
        if (sourceType != (targetType = DataTypeManager.getDataTypeClass((String)ODataTypeManager.teiidType((String)expectedType.getFullyQualifiedTypeName())))) {
            Transform t = DataTypeManager.getTransform((Class)sourceType, (Class)targetType);
            if (t == null && BlobType.class == targetType && sourceType == ClobType.class) {
                return OProperties.binary((String)propName, (byte[])ClobType.getString((Clob)((Clob)value)).getBytes());
            }
            if (t == null && BlobType.class == targetType && sourceType == SQLXML.class) {
                return OProperties.binary((String)propName, (byte[])((SQLXML)value).getString().getBytes());
            }
            return OProperties.simple((String)propName, (EdmSimpleType)expectedType, (Object)(t != null ? t.transform(value) : value));
        }
        return OProperties.simple((String)propName, (EdmSimpleType)expectedType, (Object)value);
    }

    private OEntity getEntity(ResultSet rs, Map<String, EdmProperty> propertyTypes, Map<String, Boolean> columns, EdmEntitySet entitySet) throws TransformationException, SQLException, IOException {
        HashMap<String, OProperty> properties = new HashMap<String, OProperty>();
        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
            Object value = rs.getObject(i + 1);
            String propName = rs.getMetaData().getColumnLabel(i + 1);
            EdmSimpleType type = (EdmSimpleType)propertyTypes.get(propName).getType();
            OProperty property = this.buildPropery(propName, type, value);
            properties.put(rs.getMetaData().getColumnLabel(i + 1), property);
        }
        OEntityKey key = OEntityKey.infer((EdmEntitySet)entitySet, new ArrayList(properties.values()));
        ArrayList<ORelatedEntityLink> links = new ArrayList<ORelatedEntityLink>();
        for (EdmNavigationProperty navProperty : entitySet.getType().getNavigationProperties()) {
            links.add(OLinks.relatedEntity((String)navProperty.getRelationship().getName(), (String)navProperty.getToRole().getRole(), (String)key.toKeyString()));
        }
        ArrayList projected = new ArrayList();
        for (Map.Entry<String, Boolean> entry : columns.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().booleanValue()) continue;
            projected.add(properties.get(entry.getKey()));
        }
        return OEntities.create((EdmEntitySet)entitySet, (OEntityKey)key, projected, links);
    }

    public int getCount() {
        return this.count;
    }

    public String nextToken() {
        if (this.size() < this.batchSize) {
            return null;
        }
        return String.valueOf(this.skipSize + this.size());
    }
}

