/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmReferentialConstraint;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.ODataPlugin;
import org.teiid.translator.odata.ODataTypeManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ODataEntitySchemaBuilder {
    public static EdmDataServices buildMetadata(MetadataStore metadataStore) {
        try {
            ArrayList edmSchemas = new ArrayList();
            ODataEntitySchemaBuilder.buildEntityTypes((MetadataStore)metadataStore, edmSchemas);
            ODataEntitySchemaBuilder.buildFunctionImports((MetadataStore)metadataStore, edmSchemas);
            ODataEntitySchemaBuilder.buildAssosiationSets((MetadataStore)metadataStore, edmSchemas);
            return EdmDataServices.newBuilder().addSchemas(edmSchemas).build();
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static EdmEntitySet.Builder findEntitySet(List<EdmSchema.Builder> edmSchemas, String schemaName, String enitityName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            for (EdmEntityContainer.Builder entityContainter : modelSchema.getEntityContainers()) {
                for (EdmEntitySet.Builder entitySet : entityContainter.getEntitySets()) {
                    if (!entitySet.getName().equals(enitityName)) continue;
                    return entitySet;
                }
            }
        }
        return null;
    }

    static EdmSchema.Builder findSchema(List<EdmSchema.Builder> edmSchemas, String schemaName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            return modelSchema;
        }
        return null;
    }

    static EdmEntityType.Builder findEntityType(List<EdmSchema.Builder> edmSchemas, String schemaName, String enitityName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            for (EdmEntityType.Builder type : modelSchema.getEntityTypes()) {
                if (!type.getName().equals(enitityName)) continue;
                return type;
            }
        }
        return null;
    }

    static EdmEntityContainer.Builder findEntityContainer(List<EdmSchema.Builder> edmSchemas, String schemaName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            Iterator i$;
            if (!modelSchema.getNamespace().equals(schemaName) || !(i$ = modelSchema.getEntityContainers().iterator()).hasNext()) continue;
            EdmEntityContainer.Builder entityContainter = (EdmEntityContainer.Builder)i$.next();
            return entityContainter;
        }
        return null;
    }

    private static void buildEntityTypes(MetadataStore metadataStore, List<EdmSchema.Builder> edmSchemas) {
        for (Schema schema : metadataStore.getSchemaList()) {
            ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
            ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
            for (Table table : schema.getTables().values()) {
                KeyRecord primaryKey = table.getPrimaryKey();
                List uniques = table.getUniqueKeys();
                if (primaryKey == null && uniques.isEmpty()) {
                    LogManager.logDetail((String)"org.teiid.ODATA", (Object[])new Object[]{ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16002, new Object[]{table.getFullName()})});
                    continue;
                }
                EdmEntityType.Builder entityType = (EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setName(table.getName())).setNamespace(schema.getName());
                if (primaryKey != null) {
                    for (Column c : primaryKey.getColumns()) {
                        entityType.addKeys(new String[]{c.getName()});
                    }
                } else {
                    for (Column c : ((KeyRecord)uniques.get(0)).getColumns()) {
                        entityType.addKeys(new String[]{c.getName()});
                    }
                }
                for (Column c : table.getColumns()) {
                    EdmProperty.Builder property = EdmProperty.newBuilder((String)c.getName()).setType((EdmType)ODataTypeManager.odataType((String)c.getDatatype().getRuntimeTypeName())).setNullable(c.getNullType() == BaseColumn.NullType.Nullable);
                    if (c.getDatatype().getRuntimeTypeName().equals("string")) {
                        property.setFixedLength(Boolean.valueOf(c.isFixedLength())).setMaxLength(Integer.valueOf(c.getLength())).setUnicode(Boolean.valueOf(true));
                    }
                    entityType.addProperties(new EdmProperty.Builder[]{property});
                }
                EdmEntitySet.Builder entitySet = EdmEntitySet.newBuilder().setName(table.getName()).setEntityType(entityType);
                entityType.setNamespace(schema.getName());
                entitySets.add(entitySet);
                entityTypes.add(entityType);
            }
            EdmEntityContainer.Builder entityContainer = EdmEntityContainer.newBuilder().setName(schema.getName()).setIsDefault(false).addEntitySets(entitySets);
            EdmSchema.Builder modelSchema = EdmSchema.newBuilder().setNamespace(schema.getName()).addEntityTypes(entityTypes).addEntityContainers(new EdmEntityContainer.Builder[]{entityContainer});
            edmSchemas.add(modelSchema);
        }
    }

    private static void buildAssosiationSets(MetadataStore metadataStore, List<EdmSchema.Builder> edmSchemas) {
        for (Schema schema : metadataStore.getSchemaList()) {
            EdmSchema.Builder odataSchema = ODataEntitySchemaBuilder.findSchema(edmSchemas, (String)schema.getName());
            EdmEntityContainer.Builder entityContainer = ODataEntitySchemaBuilder.findEntityContainer(edmSchemas, (String)schema.getName());
            ArrayList<EdmAssociationSet.Builder> assosiationSets = new ArrayList<EdmAssociationSet.Builder>();
            ArrayList<EdmAssociation.Builder> assosiations = new ArrayList<EdmAssociation.Builder>();
            for (Table table : schema.getTables().values()) {
                for (ForeignKey fk : table.getForeignKeys()) {
                    EdmEntitySet.Builder entitySet = ODataEntitySchemaBuilder.findEntitySet(edmSchemas, (String)schema.getName(), (String)table.getName());
                    EdmEntitySet.Builder refEntitySet = ODataEntitySchemaBuilder.findEntitySet(edmSchemas, (String)schema.getName(), (String)fk.getReferenceTableName());
                    EdmEntityType.Builder entityType = ODataEntitySchemaBuilder.findEntityType(edmSchemas, (String)schema.getName(), (String)table.getName());
                    EdmEntityType.Builder refEntityType = ODataEntitySchemaBuilder.findEntityType(edmSchemas, (String)schema.getName(), (String)fk.getReferenceTableName());
                    boolean onetoone = ODataEntitySchemaBuilder.sameColumnSet((KeyRecord)table.getPrimaryKey(), (KeyRecord)fk);
                    EdmAssociationEnd.Builder endSelf = EdmAssociationEnd.newBuilder().setRole(table.getName()).setType(entityType).setMultiplicity(onetoone ? EdmMultiplicity.ZERO_TO_ONE : EdmMultiplicity.MANY);
                    EdmAssociationEnd.Builder endRef = EdmAssociationEnd.newBuilder().setRole(fk.getReferenceTableName()).setType(refEntityType).setMultiplicity(EdmMultiplicity.ZERO_TO_ONE);
                    EdmAssociation.Builder association = EdmAssociation.newBuilder();
                    association.setName(table.getName() + "_" + fk.getName());
                    association.setEnds(endSelf, endRef);
                    association.setNamespace(refEntityType.getFullyQualifiedTypeName().substring(0, refEntityType.getFullyQualifiedTypeName().indexOf(46)));
                    assosiations.add(association);
                    if (fk.getReferenceColumns() != null) {
                        EdmReferentialConstraint.Builder erc = EdmReferentialConstraint.newBuilder();
                        erc.setPrincipalRole(fk.getReferenceTableName());
                        erc.addPrincipalReferences(fk.getReferenceColumns());
                        erc.setDependentRole(table.getName());
                        erc.addDependentReferences(ODataEntitySchemaBuilder.getColumnNames((List)fk.getColumns()));
                        association.setRefConstraint(erc);
                    }
                    EdmNavigationProperty.Builder nav = EdmNavigationProperty.newBuilder((String)fk.getReferenceTableName());
                    nav.setRelationshipName(fk.getName());
                    nav.setFromToName(table.getName(), fk.getReferenceTableName());
                    nav.setRelationship(association);
                    nav.setFromTo(endSelf, endRef);
                    entityType.addNavigationProperties(new EdmNavigationProperty.Builder[]{nav});
                    EdmNavigationProperty.Builder refNav = EdmNavigationProperty.newBuilder((String)table.getName());
                    refNav.setRelationshipName(fk.getName());
                    refNav.setFromToName(fk.getReferenceTableName(), table.getName());
                    refNav.setRelationship(association);
                    refNav.setFromTo(endRef, endSelf);
                    refEntityType.addNavigationProperties(new EdmNavigationProperty.Builder[]{refNav});
                    EdmAssociationSet.Builder assosiationSet = EdmAssociationSet.newBuilder().setName(table.getName() + "_" + fk.getName()).setAssociationName(fk.getName());
                    EdmAssociationSetEnd.Builder endOne = EdmAssociationSetEnd.newBuilder().setEntitySet(entitySet).setRoleName(table.getName()).setRole(EdmAssociationEnd.newBuilder().setType(entityType).setRole(entityType.getName()));
                    EdmAssociationSetEnd.Builder endTwo = EdmAssociationSetEnd.newBuilder().setEntitySet(refEntitySet).setRoleName(fk.getReferenceTableName()).setRole(EdmAssociationEnd.newBuilder().setType(refEntityType).setRole(refEntityType.getName()));
                    assosiationSet.setEnds(endOne, endTwo);
                    assosiationSet.setAssociation(association);
                    assosiationSets.add(assosiationSet);
                }
            }
            entityContainer.addAssociationSets(assosiationSets);
            odataSchema.addAssociations(assosiations);
        }
    }

    private static void buildFunctionImports(MetadataStore metadataStore, List<EdmSchema.Builder> edmSchemas) {
        for (Schema schema : metadataStore.getSchemaList()) {
            EdmSchema.Builder odataSchema = ODataEntitySchemaBuilder.findSchema(edmSchemas, (String)schema.getName());
            EdmEntityContainer.Builder entityContainer = ODataEntitySchemaBuilder.findEntityContainer(edmSchemas, (String)schema.getName());
            for (Procedure proc : schema.getProcedures().values()) {
                EdmFunctionImport.Builder edmProcedure = EdmFunctionImport.newBuilder();
                edmProcedure.setName(proc.getName());
                String httpMethod = "POST";
                for (ProcedureParameter pp : proc.getParameters()) {
                    if (pp.getName().equals("return")) {
                        httpMethod = "GET";
                        edmProcedure.setReturnType((EdmType)ODataTypeManager.odataType((String)pp.getDatatype().getRuntimeTypeName()));
                        continue;
                    }
                    EdmFunctionParameter.Builder param = EdmFunctionParameter.newBuilder();
                    param.setName(pp.getName());
                    param.setType((EdmType)ODataTypeManager.odataType((String)pp.getDatatype().getRuntimeTypeName()));
                    if (pp.getType() == ProcedureParameter.Type.In) {
                        param.setMode(EdmFunctionParameter.Mode.In);
                    } else if (pp.getType() == ProcedureParameter.Type.InOut) {
                        param.setMode(EdmFunctionParameter.Mode.InOut);
                    } else if (pp.getType() == ProcedureParameter.Type.Out) {
                        param.setMode(EdmFunctionParameter.Mode.Out);
                    }
                    param.setNullable(Boolean.valueOf(pp.getNullType() == BaseColumn.NullType.Nullable));
                    edmProcedure.addParameters(new EdmFunctionParameter.Builder[]{param});
                }
                ColumnSet returnColumns = proc.getResultSet();
                if (returnColumns != null) {
                    httpMethod = "GET";
                    EdmComplexType.Builder complexType = EdmComplexType.newBuilder();
                    complexType.setName(proc.getName() + "_" + returnColumns.getName());
                    complexType.setNamespace(schema.getName());
                    for (Column c : returnColumns.getColumns()) {
                        EdmProperty.Builder property = EdmProperty.newBuilder((String)c.getName()).setType((EdmType)ODataTypeManager.odataType((String)c.getDatatype().getRuntimeTypeName())).setNullable(c.getNullType() == BaseColumn.NullType.Nullable);
                        if (c.getDatatype().getRuntimeTypeName().equals("string")) {
                            property.setFixedLength(Boolean.valueOf(c.isFixedLength())).setMaxLength(Integer.valueOf(c.getLength())).setUnicode(Boolean.valueOf(true));
                        }
                        complexType.addProperties(new EdmProperty.Builder[]{property});
                    }
                    odataSchema.addComplexTypes(new EdmComplexType.Builder[]{complexType});
                    edmProcedure.setIsCollection(true);
                    edmProcedure.setReturnType((EdmType.Builder)EdmCollectionType.newBuilder().setCollectionType((EdmType.Builder)complexType).setKind(EdmProperty.CollectionKind.Collection));
                }
                edmProcedure.setHttpMethod(httpMethod);
                entityContainer.addFunctionImports(new EdmFunctionImport.Builder[]{edmProcedure});
            }
        }
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    static boolean sameColumnSet(KeyRecord recordOne, KeyRecord recordTwo) {
        if (recordOne == null || recordTwo == null) {
            return false;
        }
        List setOne = recordOne.getColumns();
        List setTwo = recordTwo.getColumns();
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (int i = 0; i < setOne.size(); ++i) {
            Column one = (Column)setOne.get(i);
            Column two = (Column)setTwo.get(i);
            if (one.getName().equals(two.getName())) continue;
            return false;
        }
        return true;
    }
}

