/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.ServerErrorException;
import org.odata4j.expression.Expression;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.Responses;
import org.odata4j.producer.SimpleResponse;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.odata.Client;
import org.teiid.odata.EntityList;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.SQLParam;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataTypeManager;
import org.teiid.transport.LocalServerConnection;

public class LocalClient
implements Client {
    private static final String BATCH_SIZE = "batch-size";
    private static final String SKIPTOKEN_TIME = "skiptoken-cache-time";
    private MetadataStore metadataStore;
    private String vdbName;
    private int vdbVersion;
    private int batchSize;
    private long cacheTime;
    private String transportName;
    private String connectionString;
    private EdmDataServices edmMetaData;
    private long lastLookup = -1L;
    private TeiidDriver driver = TeiidDriver.getInstance();

    public LocalClient(String vdbName, int vdbVersion, Properties props) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.batchSize = PropertiesUtils.getIntProperty((Properties)props, (String)BATCH_SIZE, (int)256);
        this.cacheTime = PropertiesUtils.getLongProperty((Properties)props, (String)SKIPTOKEN_TIME, (long)300000L);
        this.transportName = props.getProperty("transportName", "odata");
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:teiid:").append(this.vdbName).append(".").append(this.vdbVersion).append(";");
        sb.append("PassthroughAuthentication=true;");
        sb.append("transportName").append("=").append(this.transportName).append(";");
        sb.append("waitForLoad").append("=").append("0;");
        this.connectionString = sb.toString();
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public int getVDBVersion() {
        return this.vdbVersion;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    private ConnectionImpl getConnection() throws SQLException {
        return this.driver.connect(this.connectionString, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResponse executeCall(String sql, List<SQLParam> parameters, EdmType returnType) {
        OCollection.Builder resultRows2;
        ResultSetImpl rs;
        ConnectionImpl connection = null;
        try {
            boolean results;
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            CallableStatementImpl stmt = connection.prepareCall(sql);
            int i = 1;
            if (returnType != null && returnType.isSimple()) {
                stmt.registerOutParameter(i++, JDBCSQLTypeInfo.getSQLType((String)ODataTypeManager.teiidType((String)returnType.getFullyQualifiedTypeName())));
            }
            if (!parameters.isEmpty()) {
                for (SQLParam param : parameters) {
                    stmt.setObject(i++, param.value, param.sqlType.intValue());
                }
            }
            if (!(results = stmt.execute())) {
                if (returnType != null && returnType.isSimple()) {
                    Object result = stmt.getObject(1);
                    if (result == null) {
                        result = Expression.null_();
                    }
                    SimpleResponse resultRows2 = Responses.simple((EdmSimpleType)((EdmSimpleType)returnType), (String)"return", (Object)result);
                    return resultRows2;
                }
                SimpleResponse simpleResponse = Responses.simple((EdmSimpleType)EdmSimpleType.INT32, (Object)1);
                return simpleResponse;
            }
            rs = stmt.getResultSet();
            resultRows2 = OCollections.newBuilder((EdmType)returnType);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
        while (true) {
            if (!rs.next()) {
                String collectionName = returnType.getFullyQualifiedTypeName();
                collectionName = collectionName.replace("(", "_");
                collectionName = collectionName.replace(")", "_");
                return Responses.collection((OCollection)resultRows2.build(), null, null, null, (String)collectionName);
            }
            int idx = 1;
            ArrayList<OProperty> row = new ArrayList<OProperty>();
            for (EdmProperty prop : ((EdmComplexType)((EdmCollectionType)returnType).getItemType()).getProperties()) {
                row.add(OProperties.simple((String)prop.getName(), (Object)rs.getObject(idx++)));
            }
            OComplexObject erow = OComplexObjects.create((EdmComplexType)((EdmComplexType)((EdmCollectionType)returnType).getItemType()), row);
            resultRows2.add((OObject)erow);
        }
    }

    public MetadataStore getMetadataStore() {
        CompositeMetadataStore store = null;
        ConnectionImpl connection = null;
        long currentTime = System.currentTimeMillis();
        if (this.metadataStore == null || this.lastLookup == -1L || currentTime - this.lastLookup > this.cacheTime) {
            try {
                connection = this.getConnection();
                LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                VDBMetaData vdb = lsc.getWorkContext().getVDB();
                if (vdb == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16001, new Object[]{this.vdbName, this.vdbVersion}));
                }
                store = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
            }
            catch (SQLException e) {
                throw new ServerErrorException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        if (this.metadataStore == null || this.metadataStore != store) {
            this.metadataStore = store;
            this.edmMetaData = null;
        }
        return this.metadataStore;
    }

    public EntityList executeSQL(Query query, List<SQLParam> parameters, EdmEntitySet entitySet, Map<String, Boolean> projectedColumns, boolean useSkipToken, String skipToken, boolean getCount) {
        Connection connection = null;
        try {
            if (useSkipToken) {
                CacheHint hint = new CacheHint();
                hint.setTtl(Long.valueOf(this.cacheTime));
                hint.setScope(CacheDirective.Scope.USER);
                query.setCacheHint(hint);
            }
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatement stmt = connection.prepareStatement(sql, 1004, 1007);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType);
                }
            }
            ResultSet rs = stmt.executeQuery();
            int skipSize = 0;
            if (skipToken != null) {
                skipSize = Integer.parseInt(skipToken);
            }
            EntityList entityList = new EntityList(projectedColumns, entitySet, rs, skipSize, this.batchSize, getCount);
            return entityList;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public CountResponse executeCount(Query query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            stmt.close();
            CountResponse countResponse = Responses.count((long)count);
            return countResponse;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public int executeUpdate(Command query, List<SQLParam> parameters) {
        ConnectionImpl connection = null;
        try {
            String sql = query.toString();
            LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Teiid-Query:", (Object)sql);
            connection = this.getConnection();
            PreparedStatementImpl stmt = connection.prepareStatement(sql);
            if (!parameters.isEmpty()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    stmt.setObject(i + 1, parameters.get((int)i).value, parameters.get((int)i).sqlType.intValue());
                }
            }
            int count = stmt.executeUpdate();
            stmt.close();
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public EdmDataServices getMetadata() {
        if (this.edmMetaData == null) {
            this.edmMetaData = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)this.getMetadataStore());
        }
        return this.edmMetaData;
    }
}

