/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jboss.resteasy.spi.NotFoundException;
import org.odata4j.expression.AggregateAllFunction;
import org.odata4j.expression.AndExpression;
import org.odata4j.expression.BinaryCommonExpression;
import org.odata4j.expression.BinaryLiteral;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.BooleanLiteral;
import org.odata4j.expression.ByteLiteral;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.DateTimeLiteral;
import org.odata4j.expression.DecimalLiteral;
import org.odata4j.expression.DoubleLiteral;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.GeExpression;
import org.odata4j.expression.GtExpression;
import org.odata4j.expression.GuidLiteral;
import org.odata4j.expression.Int64Literal;
import org.odata4j.expression.IntegralLiteral;
import org.odata4j.expression.IsofExpression;
import org.odata4j.expression.LeExpression;
import org.odata4j.expression.LtExpression;
import org.odata4j.expression.NeExpression;
import org.odata4j.expression.NegateExpression;
import org.odata4j.expression.NotExpression;
import org.odata4j.expression.NullLiteral;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.SByteLiteral;
import org.odata4j.expression.SingleLiteral;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.TimeLiteral;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.Table;
import org.teiid.odata.ODataHierarchyVisitor;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.ODataSQLBuilder;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ODataAggregateAnyBuilder
extends ODataHierarchyVisitor {
    private Stack<Expression> stack = new Stack();
    private AggregateAllFunction parentExpr;
    private GroupSymbol childGroup;
    private GroupSymbol parentGroup;
    private Table parent;
    private Table childTable;

    public ODataAggregateAnyBuilder(AggregateAllFunction expr, Table parent, GroupSymbol parentGroup, Table childTable, GroupSymbol childGroup) {
        this.parentExpr = expr;
        this.parent = parent;
        this.parentGroup = parentGroup;
        this.childTable = childTable;
        this.childGroup = childGroup;
        this.visitNode((CommonExpression)expr.getPredicate());
    }

    public Criteria getCriteria() {
        return (Criteria)this.stack.pop();
    }

    public void visit(EqExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 1);
    }

    public void visit(GeExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 5);
    }

    private QueryCommand buildSubquery(Expression projected) {
        Criteria criteria = null;
        for (ForeignKey fk : this.childTable.getForeignKeys()) {
            int i;
            if (!((Table)fk.getPrimaryKey().getParent()).equals((Object)this.parent)) continue;
            List refColumns = fk.getReferenceColumns();
            if (refColumns == null) {
                refColumns = ODataSQLBuilder.getColumnNames((List)this.childTable.getPrimaryKey().getColumns());
            }
            List pkColumns = ODataSQLBuilder.getColumnNames((List)this.parent.getPrimaryKey().getColumns());
            ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
            for (i = 0; i < refColumns.size(); ++i) {
                critList.add(new CompareCriteria((Expression)new ElementSymbol((String)pkColumns.get(i), this.parentGroup), 1, (Expression)new ElementSymbol((String)refColumns.get(i), this.childGroup)));
            }
            criteria = (Criteria)critList.get(0);
            for (i = 1; i < critList.size(); ++i) {
                criteria = new CompoundCriteria(0, criteria, (Criteria)critList.get(i));
            }
        }
        Select s1 = new Select();
        s1.addSymbol(projected);
        From f1 = new From();
        f1.addGroup(this.childGroup);
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        q1.setCriteria(criteria);
        return q1;
    }

    public void visit(GtExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 3);
    }

    public void visit(IsofExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(LeExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 6);
    }

    public void visit(LtExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 4);
    }

    public void visit(NeExpression expr) {
        this.buildCriteria((BinaryCommonExpression)expr, 2);
    }

    public void visit(NegateExpression expr) {
        this.visitNode(expr.getExpression());
        Expression ex = (Expression)this.stack.pop();
        this.stack.push(new Function("*", new Expression[]{new Constant((Object)-1), ex}));
    }

    public void visit(NotExpression expr) {
    }

    public void visit(AndExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(OrExpression expr) {
        throw new UnsupportedOperationException();
    }

    public void visit(BoolParenExpression expr) {
        throw new UnsupportedOperationException();
    }

    private void buildCriteria(BinaryCommonExpression expr, int op) {
        this.visitNode(expr.getLHS());
        this.visitNode(expr.getRHS());
        Expression rhs = (Expression)this.stack.pop();
        Expression lhs = (Expression)this.stack.pop();
        SubqueryCompareCriteria critera = new SubqueryCompareCriteria(rhs, this.buildSubquery(lhs), op, 4);
        this.stack.push(critera);
    }

    public void visit(EntitySimpleProperty expr) {
        int idx;
        String property = expr.getPropertyName();
        if (!property.substring(0, idx = property.indexOf(47)).equals(this.parentExpr.getVariable())) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16010, new Object[0]));
        }
        this.stack.push(new ElementSymbol(property.substring(idx + 1), this.childGroup));
    }

    public void visit(BooleanLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(DateTimeLiteral expr) {
        this.stack.add(new Constant((Object)new Timestamp(expr.getValue().toDateTime().getMillis())));
    }

    public void visit(DecimalLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(GuidLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue().toString()));
    }

    public void visit(BinaryLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(ByteLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(SByteLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(SingleLiteral expr) {
        this.stack.add(new Constant((Object)Float.valueOf(expr.getValue())));
    }

    public void visit(DoubleLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(IntegralLiteral expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(Int64Literal expr) {
        this.stack.add(new Constant((Object)expr.getValue()));
    }

    public void visit(NullLiteral expr) {
        this.stack.push(new Constant(null));
    }

    public void visit(StringLiteral expr) {
        this.stack.push(new Constant((Object)expr.getValue()));
    }

    public void visit(TimeLiteral expr) {
        this.stack.push(new Constant((Object)new Time(expr.getValue().toDateTimeToday().getMillis())));
    }
}

