/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OQueryRequest;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.internal.EntitySegment;

public abstract class AbstractConsumerQueryRequestBase<T>
implements OQueryRequest<T> {
    private final ODataClient client;
    private final String serviceRootUri;
    private final EdmDataServices metadata;
    private Integer top;
    private Integer skip;
    private String orderBy;
    private String filter;
    private String select;
    private String expand;
    private String lastSegment;
    private EdmEntitySet entitySet;
    private final List<EntitySegment> segments = new ArrayList<EntitySegment>();
    private final Map<String, String> customs = new HashMap<String, String>();

    public AbstractConsumerQueryRequestBase(ODataClient client, String serviceRootUri, EdmDataServices metadata, String lastSegment) {
        EdmFunctionImport function;
        this.client = client;
        this.serviceRootUri = serviceRootUri;
        this.metadata = metadata;
        this.lastSegment = lastSegment;
        this.entitySet = metadata.findEdmEntitySet(lastSegment);
        if (this.entitySet == null && (function = metadata.findEdmFunctionImport(lastSegment)) != null) {
            this.entitySet = function.getEntitySet();
        }
    }

    protected ODataClient getClient() {
        return this.client;
    }

    protected EdmEntitySet getEntitySet() {
        return this.entitySet;
    }

    protected String getServiceRootUri() {
        return this.serviceRootUri;
    }

    protected EdmDataServices getMetadata() {
        return this.metadata;
    }

    protected ODataClientRequest buildRequest(Func1<String, String> pathModification) {
        String path = Enumerable.create(this.segments).join("/");
        path = path + (path.length() == 0 ? "" : "/") + this.lastSegment;
        if (pathModification != null) {
            path = (String)pathModification.apply((Object)path);
        }
        ODataClientRequest request = ODataClientRequest.get(this.serviceRootUri + path);
        if (this.top != null) {
            request = request.queryParam("$top", Integer.toString(this.top));
        }
        if (this.skip != null) {
            request = request.queryParam("$skip", Integer.toString(this.skip));
        }
        if (this.orderBy != null) {
            request = request.queryParam("$orderby", this.orderBy);
        }
        if (this.filter != null) {
            request = request.queryParam("$filter", this.filter);
        }
        if (this.select != null) {
            request = request.queryParam("$select", this.select);
        }
        for (String name : this.customs.keySet()) {
            request = request.queryParam(name, this.customs.get(name));
        }
        if (this.expand != null) {
            request = request.queryParam("$expand", this.expand);
        }
        return request;
    }

    @Override
    public OQueryRequest<T> top(int top) {
        this.top = top;
        return this;
    }

    @Override
    public OQueryRequest<T> skip(int skip) {
        this.skip = skip;
        return this;
    }

    @Override
    public OQueryRequest<T> orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @Override
    public OQueryRequest<T> filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public OQueryRequest<T> select(String select) {
        this.select = select;
        return this;
    }

    @Override
    public OQueryRequest<T> expand(String expand) {
        this.expand = expand;
        return this;
    }

    @Override
    public OQueryRequest<T> nav(Object keyValue, String navProperty) {
        return this.nav(OEntityKey.create(keyValue), navProperty);
    }

    @Override
    public OQueryRequest<T> nav(OEntityKey key, String navProperty) {
        this.segments.add(new EntitySegment(this.lastSegment, key));
        this.lastSegment = navProperty;
        this.entitySet = this.metadata.getEdmEntitySet(this.entitySet.getType().findNavigationProperty(navProperty).getToRole().getType());
        return this;
    }

    @Override
    public OQueryRequest<T> custom(String name, String value) {
        this.customs.put(name, value);
        return this;
    }

    protected List<EntitySegment> getSegments() {
        return this.segments;
    }
}

