/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.util.HashMap;
import java.util.Map;
import org.odata4j.format.Entry;
import org.odata4j.format.SingleLink;

public class ODataClientRequest {
    private final String method;
    private final String url;
    private final Map<String, String> headers;
    private final Map<String, String> queryParams;
    private final Object payload;

    public ODataClientRequest(String method, String url, Map<String, String> headers, Map<String, String> queryParams, Object payload) {
        this.method = method;
        this.url = url;
        this.headers = headers == null ? new HashMap() : headers;
        this.queryParams = queryParams == null ? new HashMap() : queryParams;
        this.payload = payload;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Object getPayload() {
        return this.payload;
    }

    public static ODataClientRequest get(String url) {
        return new ODataClientRequest("GET", url, null, null, null);
    }

    public static ODataClientRequest post(String url, Entry entry) {
        return new ODataClientRequest("POST", url, null, null, entry);
    }

    public static ODataClientRequest post(String url, SingleLink link) {
        return new ODataClientRequest("POST", url, null, null, link);
    }

    public static ODataClientRequest put(String url, Entry entry) {
        return new ODataClientRequest("PUT", url, null, null, entry);
    }

    public static ODataClientRequest put(String url, SingleLink link) {
        return new ODataClientRequest("PUT", url, null, null, link);
    }

    public static ODataClientRequest merge(String url, Entry entry) {
        return new ODataClientRequest("MERGE", url, null, null, entry);
    }

    public static ODataClientRequest merge(String url, SingleLink link) {
        return new ODataClientRequest("MERGE", url, null, null, link);
    }

    public static ODataClientRequest delete(String url) {
        return new ODataClientRequest("DELETE", url, null, null, null);
    }

    public ODataClientRequest queryParam(String name, String value) {
        this.getQueryParams().put(name, value);
        return new ODataClientRequest(this.getMethod(), this.getUrl(), this.getHeaders(), this.getQueryParams(), this.getPayload());
    }

    public ODataClientRequest header(String name, String value) {
        this.headers.put(name, value);
        return new ODataClientRequest(this.method, this.url, this.headers, this.queryParams, this.payload);
    }

    public ODataClientRequest method(String method) {
        return new ODataClientRequest(method, this.url, this.headers, this.queryParams, this.payload);
    }
}

