/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.io.Writer;
import javax.ws.rs.core.UriInfo;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.xml.XmlFormatWriter;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.XMLFactoryProvider2;
import org.odata4j.stax2.XMLWriter2;

public class AtomServiceDocumentFormatWriter
extends XmlFormatWriter
implements FormatWriter<EdmDataServices> {
    @Override
    public String getContentType() {
        return "application/xml;charset=utf-8";
    }

    @Override
    public void write(UriInfo uriInfo, Writer w, EdmDataServices target) {
        XMLWriter2 writer = XMLFactoryProvider2.getInstance().newXMLWriterFactory2().createXMLWriter(w);
        writer.startDocument();
        String xmlns = "http://www.w3.org/2007/app";
        writer.startElement(new QName2("service"), xmlns);
        writer.writeAttribute(new QName2("xml:base"), uriInfo.getBaseUri().toString());
        writer.writeNamespace("atom", "http://www.w3.org/2005/Atom");
        writer.writeNamespace("app", "http://www.w3.org/2007/app");
        writer.startElement(new QName2("workspace"));
        AtomServiceDocumentFormatWriter.writeAtomTitle(writer, "http://www.w3.org/2005/Atom", "Default");
        for (EdmEntitySet ees : target.getEntitySets()) {
            writer.startElement("collection");
            writer.writeAttribute("href", ees.getName());
            AtomServiceDocumentFormatWriter.writeAtomTitle(writer, "http://www.w3.org/2005/Atom", ees.getName());
            writer.endElement("collection");
        }
        writer.endElement("workspace");
        writer.endDocument();
    }

    private static void writeAtomTitle(XMLWriter2 writer, String atom, String title) {
        writer.startElement(new QName2(atom, "title", "atom"));
        writer.writeText(title);
        writer.endElement("title");
    }
}

