/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.odata4j.core.NamedValue;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObject;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmProperty;
import org.odata4j.exceptions.NotAcceptableException;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.expression.AggregateAllFunction;
import org.odata4j.expression.AggregateAnyFunction;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.ExpressionVisitor;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.producer.QueryInfo;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.Assertion;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.odata.DocumentNode;
import org.teiid.odata.ODataAggregateAnyBuilder;
import org.teiid.odata.ODataExpressionVisitor;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.SQLParam;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.translator.odata.ODataTypeManager;

public class ODataSQLBuilder
extends ODataExpressionVisitor {
    private Query query = new Query();
    private OrderBy orderBy = new OrderBy();
    private Criteria where;
    private MetadataStore metadata;
    protected DocumentNode resultNode;
    private FromClause fromCluse = null;
    private HashMap<String, DocumentNode> assosiatedTables = new HashMap();
    private AtomicInteger groupCount = new AtomicInteger(0);
    private boolean distinct = false;

    public ODataSQLBuilder(MetadataStore metadata, boolean prepared) {
        super(prepared);
        this.metadata = metadata;
    }

    public Query selectString(String entityName, QueryInfo info, OEntityKey key, String navProperty, boolean countStar) {
        Select select = new Select();
        LinkedHashSet<String> $select = new LinkedHashSet<String>();
        if (info.select != null) {
            for (String[] property : info.select) {
                $select.add(property.getPropertyName());
            }
        }
        this.resultNode = this.buildDocumentNode(entityName);
        this.assosiatedTables.put(this.resultNode.getEntityTable().getFullName(), this.resultNode);
        if (key != null) {
            this.where = this.buildEntityKeyCriteria(this.resultNode, key);
        }
        this.fromCluse = new UnaryFromClause(this.resultNode.getEntityGroup());
        if (navProperty != null) {
            String prop = null;
            if (navProperty.startsWith("/")) {
                navProperty = navProperty.substring(1);
            }
            for (String segment : navProperty.split("/")) {
                DocumentNode joinNode;
                String[] propSplit = segment.split("\\(");
                prop = propSplit[0];
                Column column = this.findColumn(this.resultNode.getEntityTable(), prop);
                if (column != null) {
                    if (!$select.isEmpty()) {
                        throw new NotAcceptableException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16020, new Object[0]));
                    }
                    $select.add(column.getName());
                    continue;
                }
                this.resultNode = joinNode = this.joinTable(this.resultNode, this.buildDocumentNode(prop));
                if (propSplit.length <= 1) continue;
                key = OEntityKey.parse((String)("(" + propSplit[1]));
                this.where = Criteria.combineCriteria((Criteria)this.where, (Criteria)this.buildEntityKeyCriteria(this.resultNode, key));
            }
        }
        if (info != null && info.expand != null && !info.expand.isEmpty()) {
            if (info.expand.size() > 1) {
                throw new UnsupportedOperationException("Only one $expand is suported");
            }
            DocumentNode expandNode = this.joinTable(this.resultNode, this.buildDocumentNode(((EntitySimpleProperty)info.expand.get(0)).getPropertyName()));
            this.resultNode.setExpandNode(expandNode);
        }
        if (countStar) {
            AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
            select = new Select(Arrays.asList(aggregateSymbol));
        } else {
            select = this.buildSelectColumns($select, this.resultNode);
        }
        if (info.filter != null) {
            Assertion.assertTrue((boolean)this.isEmpty());
            this.visitNode((CommonExpression)info.filter);
            Object ex = this.getExpression();
            if (!(ex instanceof Criteria)) {
                ex = new ExpressionCriteria((Expression)ex);
            }
            this.where = Criteria.combineCriteria((Criteria)this.where, (Criteria)((Criteria)ex));
        }
        if (!countStar) {
            if (info.orderBy != null && !info.orderBy.isEmpty()) {
                for (OrderByExpression expr : info.orderBy) {
                    this.visitNode(expr);
                }
                this.query.setOrderBy(this.orderBy);
            } else {
                KeyRecord record = this.resultNode.getEntityTable().getPrimaryKey();
                if (record == null) {
                    record = (KeyRecord)this.resultNode.getEntityTable().getUniqueKeys().get(0);
                }
                for (Column column : record.getColumns()) {
                    OrderByExpression expr = org.odata4j.expression.Expression.orderBy((CommonExpression)org.odata4j.expression.Expression.simpleProperty((String)column.getName()), (OrderByExpression.Direction)OrderByExpression.Direction.ASCENDING);
                    this.visitNode(expr);
                }
                this.query.setOrderBy(this.orderBy);
            }
            select.setDistinct(this.distinct);
        }
        From from = new From();
        from.addClause(this.fromCluse);
        this.query.setSelect(select);
        this.query.setFrom(from);
        this.query.setCriteria(this.where);
        return this.query;
    }

    private DocumentNode buildDocumentNode(String name) {
        String alias = "g" + this.groupCount.getAndIncrement();
        return this.buildDocumentNode(name, alias);
    }

    private DocumentNode buildDocumentNode(String name, String alias) {
        Table table = this.findTable(name, this.metadata);
        if (table == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16004, new Object[]{name}));
        }
        return new DocumentNode(table, new GroupSymbol(alias, table.getFullName()));
    }

    private DocumentNode joinTable(DocumentNode parentNode, DocumentNode joinNode) {
        List<String> refColumns;
        boolean associationFound = false;
        for (ForeignKey fk : joinNode.getEntityTable().getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)parentNode.getEntityTable())) continue;
            if (this.assosiatedTables.get(joinNode.getEntityTable().getFullName()) == null) {
                refColumns = fk.getReferenceColumns();
                if (refColumns == null) {
                    refColumns = ODataSQLBuilder.getColumnNames(parentNode.getEntityTable().getPrimaryKey().getColumns());
                }
                this.addJoinTable(joinNode, JoinType.JOIN_INNER, parentNode, refColumns, ODataSQLBuilder.getColumnNames(fk.getColumns()));
            }
            associationFound = true;
            break;
        }
        for (ForeignKey fk : parentNode.getEntityTable().getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)joinNode.getEntityTable())) continue;
            if (this.assosiatedTables.get(joinNode.getEntityTable().getFullName()) == null) {
                refColumns = fk.getReferenceColumns();
                if (refColumns == null) {
                    refColumns = ODataSQLBuilder.getColumnNames(joinNode.getEntityTable().getPrimaryKey().getColumns());
                }
                this.addJoinTable(joinNode, JoinType.JOIN_INNER, parentNode, ODataSQLBuilder.getColumnNames(fk.getColumns()), refColumns);
            }
            associationFound = true;
            break;
        }
        if (!associationFound) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16003, new Object[]{joinNode.getEntityTable().getFullName(), parentNode.getEntityTable().getFullName()}));
        }
        return joinNode;
    }

    public Query callFunctionQuery(String procedureName, EdmFunctionImport function, Map<String, OFunctionParameter> inputParams, QueryInfo info) {
        GroupSymbol gs = new GroupSymbol("g0");
        Procedure proc = this.findProcedure(procedureName, this.metadata);
        this.resultNode = new DocumentNode(proc, gs);
        Select select = new Select();
        int ordinal = 1;
        if (info.select != null && !info.select.isEmpty()) {
            for (EntitySimpleProperty property : info.select) {
                for (Column column : proc.getResultSet().getColumns()) {
                    if (!column.getName().equals(property.getPropertyName())) continue;
                    this.resultNode.addProjectColumn(column.getName(), ordinal++, true, ODataTypeManager.odataType((String)column.getRuntimeType()));
                    select.addSymbol((Expression)new ElementSymbol(column.getName(), gs));
                }
            }
        } else {
            select.addSymbol((Expression)new MultipleElementSymbol(gs.getName()));
        }
        if (info.orderBy != null && !info.orderBy.isEmpty()) {
            for (OrderByExpression expr : info.orderBy) {
                this.visitNode(expr);
            }
            this.query.setOrderBy(this.orderBy);
        }
        StoredProcedure procedure = this.storedProcedure(procedureName, function, inputParams);
        SubqueryFromClause sfc = new SubqueryFromClause(gs, (Command)procedure);
        sfc.setLateral(true);
        if (info.filter != null) {
            Assertion.assertTrue((boolean)this.isEmpty());
            this.visitNode((CommonExpression)info.filter);
            Expression ex = this.getExpression();
            if (!(ex instanceof Criteria)) {
                ex = new ExpressionCriteria(ex);
            }
            this.where = Criteria.combineCriteria((Criteria)this.where, (Criteria)((Criteria)ex));
        }
        From from = new From();
        from.addClause((FromClause)sfc);
        this.query.setSelect(select);
        this.query.setFrom(from);
        this.query.setCriteria(this.where);
        return this.query;
    }

    public StoredProcedure storedProcedure(String name, EdmFunctionImport function, Map<String, OFunctionParameter> inputParams) {
        StoredProcedure procedure = new StoredProcedure();
        procedure.setProcedureName(name);
        if (!inputParams.isEmpty()) {
            for (EdmFunctionParameter edmFunctionParameter : function.getParameters()) {
                OFunctionParameter param = inputParams.get(edmFunctionParameter.getName());
                if (param == null) continue;
                SPParameter spParam = new SPParameter(this.getParameters().size() + 1, 1, edmFunctionParameter.getName());
                spParam.setExpression((Expression)new Reference(this.getParameters().size()));
                procedure.setParameter(spParam);
                Object value = ((OSimpleObject)param.getValue()).getValue();
                Integer sqlType = JDBCSQLTypeInfo.getSQLType((String)ODataTypeManager.teiidType((String)param.getType().getFullyQualifiedTypeName()));
                this.getParameters().add(new SQLParam(ODataTypeManager.convertToTeiidRuntimeType((Object)value), sqlType));
            }
        }
        procedure.setDisplayNamedParameters(true);
        return procedure;
    }

    private void addJoinTable(DocumentNode joinNode, JoinType joinType, DocumentNode parentNode, List<String> pkColumns, List<String> refColumns) {
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        for (int i = 0; i < refColumns.size(); ++i) {
            critList.add(new CompareCriteria((Expression)new ElementSymbol(pkColumns.get(i), parentNode.getEntityGroup()), 1, (Expression)new ElementSymbol(refColumns.get(i), joinNode.getEntityGroup())));
        }
        Criteria crit = (Criteria)critList.get(0);
        for (int i = 1; i < critList.size(); ++i) {
            crit = new CompoundCriteria(0, crit, (Criteria)critList.get(i));
        }
        this.fromCluse = this.fromCluse == null ? new JoinPredicate((FromClause)new UnaryFromClause(parentNode.getEntityGroup()), (FromClause)new UnaryFromClause(joinNode.getEntityGroup()), JoinType.JOIN_INNER, crit) : new JoinPredicate(this.fromCluse, (FromClause)new UnaryFromClause(joinNode.getEntityGroup()), joinType, crit);
        this.assosiatedTables.put(joinNode.getEntityTable().getFullName(), joinNode);
    }

    private Criteria buildEntityKeyCriteria(DocumentNode entityNode, OEntityKey entityKey) {
        KeyRecord pk = entityNode.getEntityTable().getPrimaryKey();
        if (entityKey.getKeyType() == OEntityKey.KeyType.SINGLE) {
            if (pk.getColumns().size() != 1) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{entityNode.getEntityTable().getFullName(), entityKey}));
            }
            Column column = (Column)entityNode.getEntityTable().getPrimaryKey().getColumns().get(0);
            return new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityNode.getEntityGroup()), 1, (Expression)new Constant(entityKey.asSingleValue()));
        }
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        Set keys = entityKey.asComplexValue();
        if (pk.getColumns().size() != keys.size()) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{entityNode.getEntityTable().getFullName(), entityKey}));
        }
        for (NamedValue key : keys) {
            Column column = this.findColumn(entityNode.getEntityTable(), key.getName());
            critList.add(new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityNode.getEntityGroup()), 1, (Expression)new Constant(key.getValue())));
        }
        return new CompoundCriteria(0, critList);
    }

    private Select buildSelectColumns(Set<String> selectColumns, DocumentNode parentNode) {
        Select select = new Select();
        int ordinal = 1;
        if (!selectColumns.isEmpty()) {
            for (Column column : parentNode.getEntityTable().getPrimaryKey().getColumns()) {
                if (parentNode.getProjectedColumns().containsKey(column.getName())) continue;
                parentNode.addProjectColumn(column.getName(), ordinal++, selectColumns.contains(column.getName()), ODataTypeManager.odataType((String)column.getRuntimeType()));
            }
            for (ForeignKey fk : parentNode.getEntityTable().getForeignKeys()) {
                for (Column column : fk.getColumns()) {
                    if (parentNode.getProjectedColumns().containsKey(column.getName())) continue;
                    parentNode.addProjectColumn(column.getName(), ordinal++, selectColumns.contains(column.getName()), ODataTypeManager.odataType((String)column.getRuntimeType()));
                }
            }
            for (String property : selectColumns) {
                Column column = this.findColumn(parentNode.getEntityTable(), property);
                if (column == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16005, new Object[]{property, parentNode.getEntityTable().getFullName()}));
                }
                if (parentNode.getProjectedColumns().containsKey(column.getName())) continue;
                parentNode.addProjectColumn(column.getName(), ordinal++, selectColumns.contains(column.getName()), ODataTypeManager.odataType((String)column.getRuntimeType()));
            }
            for (DocumentNode.ProjectedColumn pc : parentNode.getProjectedColumns().values()) {
                select.addSymbol((Expression)new ElementSymbol(pc.name(), parentNode.getEntityGroup()));
            }
        } else {
            select.addSymbol((Expression)new MultipleElementSymbol(parentNode.getEntityGroup().getName()));
        }
        if (parentNode.getExpandNode() != null) {
            select.addSymbol((Expression)new MultipleElementSymbol(parentNode.getExpandNode().getEntityGroup().getName()));
        }
        return select;
    }

    public void visit(String type) {
        throw new UnsupportedOperationException();
    }

    public void visit(OrderByExpression expr) {
        this.visitNode(expr.getExpression());
        this.visit(expr.getDirection());
    }

    public void visit(OrderByExpression.Direction direction) {
        Expression expr = this.getExpression();
        this.orderBy.addVariable(expr, direction == OrderByExpression.Direction.ASCENDING);
    }

    @Override
    public void visit(EntitySimpleProperty expr) {
        String property = expr.getPropertyName();
        if (property.indexOf(47) == -1) {
            this.setExpression((Expression)new ElementSymbol(property, this.resultNode.getEntityGroup()));
            return;
        }
        String[] segments = property.split("/");
        DocumentNode joinNode = this.joinTable(this.resultNode, this.buildDocumentNode(segments[0]));
        Column column = this.findColumn(joinNode.getEntityTable(), segments[1]);
        if (column == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16005, new Object[]{segments[1], joinNode.getEntityTable().getFullName()}));
        }
        this.setExpression((Expression)new ElementSymbol(segments[1], joinNode.getEntityGroup()));
    }

    @Override
    public GroupSymbol getDocumentGroup() {
        return this.resultNode.getEntityGroup();
    }

    public void visit(AggregateAnyFunction expr) {
        String joinTableName = ((EntitySimpleProperty)expr.getSource()).getPropertyName();
        final DocumentNode joinNode = this.buildDocumentNode(joinTableName, expr.getVariable());
        this.joinTable(this.resultNode, joinNode);
        ODataExpressionVisitor ev = new ODataExpressionVisitor(this.isPrepared()){

            @Override
            public GroupSymbol getDocumentGroup() {
                return joinNode.getEntityGroup();
            }
        };
        expr.getPredicate().visitThis((ExpressionVisitor)ev);
        this.setExpression(ev.getExpression());
        this.distinct = true;
    }

    public void visit(AggregateAllFunction expr) {
        String tblName = ((EntitySimpleProperty)expr.getSource()).getPropertyName();
        Table joinTable = this.findTable(tblName, this.metadata);
        if (joinTable == null) {
            throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16009, new Object[]{tblName}));
        }
        DocumentNode joinNode = this.buildDocumentNode(tblName, expr.getVariable());
        ODataAggregateAnyBuilder builder = new ODataAggregateAnyBuilder(expr, this.resultNode, joinNode);
        Criteria criteria = builder.getCriteria();
        this.setExpression((Expression)criteria);
    }

    private Table findTable(EdmEntitySet entity, MetadataStore store) {
        return this.findTable(entity.getType().getFullyQualifiedTypeName(), store);
    }

    private Table findTable(String tableName, MetadataStore store) {
        Table t;
        Schema s;
        int idx = tableName.indexOf(46);
        if (idx > 0 && (s = store.getSchema(tableName.substring(0, idx))) != null && (t = s.getTable(tableName.substring(idx + 1))) != null) {
            return t;
        }
        Table result = null;
        for (Schema s2 : store.getSchemaList()) {
            Table t2 = (Table)s2.getTables().get(tableName);
            if (t2 == null) continue;
            if (result != null) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{tableName}));
            }
            result = t2;
        }
        return result;
    }

    private Procedure findProcedure(String procedureName, MetadataStore store) {
        Procedure t;
        Schema s;
        int idx = procedureName.indexOf(46);
        if (idx > 0 && (s = store.getSchema(procedureName.substring(0, idx))) != null && (t = s.getProcedure(procedureName.substring(idx + 1))) != null) {
            return t;
        }
        Procedure result = null;
        for (Schema s2 : store.getSchemaList()) {
            Procedure t2 = (Procedure)s2.getProcedures().get(procedureName);
            if (t2 == null) continue;
            if (result != null) {
                throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{procedureName}));
            }
            result = t2;
        }
        return result;
    }

    private Column findColumn(Table table, String propertyName) {
        return table.getColumnByName(propertyName);
    }

    public DocumentNode getDocumentNode() {
        return this.resultNode;
    }

    OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Insert insert(EdmEntitySet entitySet, OEntity entity) {
        Table entityTable = this.findTable(entitySet, this.metadata);
        this.resultNode = new DocumentNode(entityTable, new GroupSymbol(entityTable.getFullName()));
        ArrayList<Reference> values = new ArrayList<Reference>();
        Insert insert = new Insert();
        insert.setGroup(this.resultNode.getEntityGroup());
        int i = 0;
        for (OProperty prop : entity.getProperties()) {
            EdmProperty edmProp = entitySet.getType().findProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            insert.addVariable(new ElementSymbol(column.getName(), this.resultNode.getEntityGroup()));
            values.add(new Reference(i++));
            this.getParameters().add(this.asParam(prop, edmProp));
        }
        insert.setValues(values);
        return insert;
    }

    public OEntityKey buildEntityKey(EdmEntitySet entitySet, OEntity entity, Map<String, Object> generatedKeys) {
        Table entityTable = this.findTable(entitySet, this.metadata);
        KeyRecord pk = entityTable.getPrimaryKey();
        ArrayList<OProperty> props = new ArrayList<OProperty>();
        for (Column c : pk.getColumns()) {
            OProperty prop = null;
            try {
                prop = entity.getProperty(c.getName());
            }
            catch (Exception e) {
                Object value = generatedKeys.get(c.getName());
                if (value == null) {
                    throw new NotFoundException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16016, new Object[]{entity.getEntitySetName()}));
                }
                prop = OProperties.simple((String)c.getName(), (Object)value);
            }
            props.add(prop);
        }
        return OEntityKey.infer((EdmEntitySet)entitySet, props);
    }

    public Delete delete(EdmEntitySet entitySet, OEntityKey entityKey) {
        Table entityTable = this.findTable(entitySet, this.metadata);
        this.resultNode = new DocumentNode(entityTable, new GroupSymbol(entityTable.getFullName()));
        Delete delete = new Delete();
        delete.setGroup(this.resultNode.getEntityGroup());
        delete.setCriteria(this.buildEntityKeyCriteria(this.resultNode, entityKey));
        return delete;
    }

    public Update update(EdmEntitySet entitySet, OEntity entity) {
        Table entityTable = this.findTable(entitySet, this.metadata);
        this.resultNode = new DocumentNode(entityTable, new GroupSymbol(entityTable.getFullName()));
        Update update = new Update();
        update.setGroup(this.resultNode.getEntityGroup());
        update.setCriteria(this.buildEntityKeyCriteria(this.resultNode, entity.getEntityKey()));
        int i = 0;
        for (OProperty prop : entity.getProperties()) {
            EdmProperty edmProp = entitySet.getType().findProperty(prop.getName());
            Column column = entityTable.getColumnByName(edmProp.getName());
            boolean add = true;
            for (Column c : entityTable.getPrimaryKey().getColumns()) {
                if (!c.getName().equals(column.getName())) continue;
                add = false;
            }
            if (!add) continue;
            update.addChange(new ElementSymbol(column.getName(), this.resultNode.getEntityGroup()), (Expression)new Reference(i++));
            this.getParameters().add(this.asParam(prop, edmProp));
        }
        return update;
    }

    private SQLParam asParam(OProperty<?> prop, EdmProperty edmProp) {
        return new SQLParam(ODataTypeManager.convertToTeiidRuntimeType((Object)prop.getValue()), JDBCSQLTypeInfo.getSQLType((String)ODataTypeManager.teiidType((String)edmProp.getType().getFullyQualifiedTypeName())));
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }
}

