/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;

public class EdmSchema
extends EdmItem {
    private final String namespace;
    private final String alias;
    private final ImmutableList<EdmEntityType> entityTypes;
    private final ImmutableList<EdmComplexType> complexTypes;
    private final ImmutableList<EdmAssociation> associations;
    private final ImmutableList<EdmEntityContainer> entityContainers;

    private EdmSchema(String namespace, String alias, ImmutableList<EdmEntityType> entityTypes, ImmutableList<EdmComplexType> complexTypes, ImmutableList<EdmAssociation> associations, ImmutableList<EdmEntityContainer> entityContainers, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots, ImmutableList<EdmAnnotation<?>> annotElements) {
        super(doc, annots, annotElements);
        this.namespace = namespace;
        this.alias = alias;
        this.entityTypes = entityTypes;
        this.complexTypes = complexTypes;
        this.associations = associations;
        this.entityContainers = entityContainers;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<EdmEntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public List<EdmComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    public List<EdmAssociation> getAssociations() {
        return this.associations;
    }

    public List<EdmEntityContainer> getEntityContainers() {
        return this.entityContainers;
    }

    public EdmEntityContainer findEntityContainer(String name) {
        for (EdmEntityContainer ec : this.entityContainers) {
            if (!ec.getName().equals(name)) continue;
            return ec;
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmSchema schema, EdmItem.BuilderContext context) {
        return context.newBuilder(schema, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmSchema, Builder> {
        private String namespace;
        private String alias;
        private final List<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
        private final List<EdmComplexType.Builder> complexTypes = new ArrayList<EdmComplexType.Builder>();
        private final List<EdmAssociation.Builder> associations = new ArrayList<EdmAssociation.Builder>();
        private final List<EdmEntityContainer.Builder> entityContainers = new ArrayList<EdmEntityContainer.Builder>();

        @Override
        Builder newBuilder(EdmSchema schema, EdmItem.BuilderContext context) {
            ArrayList<EdmEntityContainer.Builder> entityContainers = new ArrayList<EdmEntityContainer.Builder>();
            for (Object entityContainer : schema.entityContainers) {
                entityContainers.add(EdmEntityContainer.newBuilder((EdmEntityContainer)entityContainer, context));
            }
            ArrayList<EdmComplexType.Builder> complexTypes = new ArrayList<EdmComplexType.Builder>();
            for (Object complexType : schema.complexTypes) {
                complexTypes.add(EdmComplexType.newBuilder((EdmComplexType)complexType, context));
            }
            ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
            for (EdmEntityType entityType : schema.entityTypes) {
                entityTypes.add(EdmEntityType.newBuilder(entityType, context));
            }
            ArrayList<EdmAssociation.Builder> associations = new ArrayList<EdmAssociation.Builder>();
            for (EdmAssociation association : schema.associations) {
                associations.add(EdmAssociation.newBuilder(association, context));
            }
            return new Builder().setNamespace(schema.namespace).setAlias(schema.alias).addEntityTypes(entityTypes).addComplexTypes(complexTypes).addAssociations(associations).addEntityContainers(entityContainers);
        }

        public EdmSchema build() {
            ArrayList<EdmEntityContainer> entityContainers = new ArrayList<EdmEntityContainer>(this.entityContainers.size());
            for (EdmEntityContainer.Builder builder : this.entityContainers) {
                entityContainers.add(builder.build());
            }
            ArrayList<EdmComplexType> complexTypes = new ArrayList<EdmComplexType>(this.complexTypes.size());
            for (EdmComplexType.Builder builder : this.complexTypes) {
                complexTypes.add(builder.build());
            }
            ArrayList<EdmEntityType> arrayList = new ArrayList<EdmEntityType>(this.entityTypes.size());
            for (EdmEntityType.Builder entityType : this.entityTypes) {
                arrayList.add(entityType.build());
            }
            ArrayList<EdmAssociation> arrayList2 = new ArrayList<EdmAssociation>(this.associations.size());
            for (EdmAssociation.Builder association : this.associations) {
                arrayList2.add(association.build());
            }
            return new EdmSchema(this.namespace, this.alias, ImmutableList.copyOf(arrayList), ImmutableList.copyOf(complexTypes), ImmutableList.copyOf(arrayList2), ImmutableList.copyOf(entityContainers), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()), ImmutableList.copyOf(this.getAnnotationElements()));
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addEntityTypes(Collection<EdmEntityType.Builder> entityTypes) {
            this.entityTypes.addAll(entityTypes);
            return this;
        }

        public Builder addEntityTypes(EdmEntityType.Builder ... entityTypes) {
            this.entityTypes.addAll(Arrays.asList(entityTypes));
            return this;
        }

        public Builder addComplexTypes(Collection<EdmComplexType.Builder> complexTypes) {
            this.complexTypes.addAll(complexTypes);
            return this;
        }

        public Builder addComplexTypes(EdmComplexType.Builder ... complexTypes) {
            this.complexTypes.addAll(Arrays.asList(complexTypes));
            return this;
        }

        public Builder addAssociations(Collection<EdmAssociation.Builder> associations) {
            this.associations.addAll(associations);
            return this;
        }

        public Builder addEntityContainers(EdmEntityContainer.Builder ... entityContainers) {
            this.entityContainers.addAll(Arrays.asList(entityContainers));
            return this;
        }

        public Builder addEntityContainers(Collection<EdmEntityContainer.Builder> entityContainers) {
            this.entityContainers.addAll(entityContainers);
            return this;
        }

        public Iterable<EdmComplexType.Builder> getComplexTypes() {
            return this.complexTypes;
        }

        public List<EdmEntityType.Builder> getEntityTypes() {
            return this.entityTypes;
        }

        public List<EdmAssociation.Builder> getAssociations() {
            return this.associations;
        }

        public List<EdmEntityContainer.Builder> getEntityContainers() {
            return this.entityContainers;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public EdmEntityContainer.Builder findEntityContainer(String name) {
            for (EdmEntityContainer.Builder ec : this.entityContainers) {
                if (!ec.getName().equals(name)) continue;
                return ec;
            }
            return null;
        }

        public String dealias(String fqName) {
            if (this.alias == null || this.alias.length() == 0 || fqName == null || fqName.length() == 0 || this.namespace == null || this.namespace.length() == 0) {
                return fqName;
            }
            String aliasPrefix = this.alias + ".";
            if (fqName.startsWith(aliasPrefix)) {
                return this.namespace + "." + fqName.substring(aliasPrefix.length());
            }
            return fqName;
        }
    }
}

