/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.internal.InternalUtil;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataContextImpl;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.PropertyResponse;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.RawResponse;
import org.odata4j.producer.resources.BaseResource;
import org.odata4j.producer.resources.OptionsQueryParser;

public class PropertyRequestResource
extends BaseResource {
    private static final Logger log = Logger.getLogger(PropertyRequestResource.class.getName());

    @PUT
    public Response updateEntity(@Context Providers providers, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="navProp") String navProp) {
        log.info("NavProp: updateEntity Not supported yet.");
        throw new NotImplementedException("NavProp: updateEntity not supported yet.");
    }

    @POST
    public Response mergeEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="navProp") String navProp, String payload) throws Exception {
        String method = (String)httpHeaders.getRequestHeaders().getFirst((Object)"X-HTTP-METHOD");
        if (!"MERGE".equals(method)) {
            ODataProducer producer = BaseResource.getODataProducer(providers);
            EdmDataServices metadata = producer.getMetadata();
            EdmEntitySet ees = metadata.getEdmEntitySet(metadata.getEdmEntitySet(entitySetName).getType().findNavigationProperty(navProp).getToRole().getType());
            OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, metadata, ees.getName(), OEntityKey.parse(id));
            EntityResponse response = producer.createEntity(ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).build(), entitySetName, OEntityKey.parse(id), navProp, entity);
            if (response == null) {
                throw new NotFoundException();
            }
            StringWriter sw = new StringWriter();
            FormatWriter<EntityResponse> fw = FormatWriterFactory.getFormatWriter(EntityResponse.class, httpHeaders.getAcceptableMediaTypes(), null, null);
            fw.write(uriInfo, sw, response);
            String relid = InternalUtil.getEntityRelId(response.getEntity());
            String entryId = uriInfo.getBaseUri().toString() + relid;
            String responseEntity = sw.toString();
            return Response.ok((Object)responseEntity, (String)fw.getContentType()).status(Response.Status.CREATED).location(URI.create(entryId)).header("DataServiceVersion", (Object)ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        throw new NotImplementedException("Not supported yet.");
    }

    @DELETE
    public Response deleteEntity(@Context Providers providers, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="navProp") String navProp) {
        throw new NotImplementedException("Not supported yet.");
    }

    @GET
    @Produces(value={"application/atom+xml;charset=utf-8", "text/javascript;charset=utf-8", "application/json;charset=utf-8", "application/atom+xml", "application/xml", "application/json"})
    public Response getNavProperty(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context Providers providers, @Context SecurityContext securityContext, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="navProp") String navProp, @QueryParam(value="$inlinecount") String inlineCount, @QueryParam(value="$top") String top, @QueryParam(value="$skip") String skip, @QueryParam(value="$filter") String filter, @QueryParam(value="$orderby") String orderBy, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @QueryParam(value="$skiptoken") String skipToken, @QueryParam(value="$expand") String expand, @QueryParam(value="$select") String select) throws Exception {
        FormatWriter<BaseResponse> fwBase;
        FormatWriter<BaseResponse> fw;
        QueryInfo query = new QueryInfo(OptionsQueryParser.parseInlineCount(inlineCount), OptionsQueryParser.parseTop(top), OptionsQueryParser.parseSkip(skip), OptionsQueryParser.parseFilter(filter), OptionsQueryParser.parseOrderBy(orderBy), OptionsQueryParser.parseSkipToken(skipToken), OptionsQueryParser.parseCustomOptions(uriInfo), OptionsQueryParser.parseSelect(expand), OptionsQueryParser.parseSelect(select));
        ODataProducer producer = BaseResource.getODataProducer(providers);
        if (navProp.endsWith("/$count") || navProp.endsWith("/$count/") || navProp.contains("/$count?") || navProp.contains("/$count/?")) {
            navProp = navProp.replace("/$count", "");
            CountResponse response = producer.getNavPropertyCount(ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).build(), entitySetName, OEntityKey.parse(id), navProp, query);
            if (response == null) {
                throw new NotFoundException();
            }
            String entity = Long.toString(response.getCount());
            ODataVersion version = ODataVersion.V2;
            return Response.ok((Object)entity, (String)"text/plain;charset=utf-8").header("DataServiceVersion", (Object)version.asString).build();
        }
        BaseResponse response = producer.getNavProperty(ODataContextImpl.builder().aspect(httpHeaders).aspect(securityContext).build(), entitySetName, OEntityKey.parse(id), navProp, query);
        if (response == null) {
            throw new NotFoundException();
        }
        ODataVersion version = ODataConstants.DATA_SERVICE_VERSION;
        StringWriter sw = new StringWriter();
        if (response instanceof PropertyResponse) {
            fw = FormatWriterFactory.getFormatWriter(PropertyResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (PropertyResponse)response);
            fwBase = fw;
        } else if (response instanceof RawResponse) {
            fw = FormatWriterFactory.getFormatWriter(RawResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (PropertyResponse)((Object)((RawResponse)response)));
            fwBase = fw;
        } else if (response instanceof EntityResponse) {
            fw = FormatWriterFactory.getFormatWriter(EntityResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (PropertyResponse)((Object)((EntityResponse)response)));
            fwBase = fw;
        } else if (response instanceof EntitiesResponse) {
            fw = FormatWriterFactory.getFormatWriter(EntitiesResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (PropertyResponse)((Object)((EntitiesResponse)response)));
            fwBase = fw;
            version = MediaType.valueOf((String)fw.getContentType()).isCompatible(MediaType.APPLICATION_JSON_TYPE) ? ODataVersion.V2 : ODataVersion.V2;
        } else {
            throw new NotImplementedException("Unknown BaseResponse type: " + response.getClass().getName());
        }
        String entity = sw.toString();
        return Response.ok((Object)entity, (String)fwBase.getContentType()).header("DataServiceVersion", (Object)version.asString).build();
    }
}

