/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odata;

import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.odata4j.producer.ODataProducer;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.LRUCache;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.logging.LogManager;
import org.teiid.odata.LocalClient;
import org.teiid.odata.ODataPlugin;
import org.teiid.odata.TeiidProducer;
import org.teiid.transport.LocalServerConnection;
import org.teiid.vdb.runtime.VDBKey;

@Provider
public class TeiidProducerProvider
implements ContextResolver<ODataProducer>,
VDBLifeCycleListener {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ServletContext context;
    protected Map<VDBKey, SoftReference<LocalClient>> clientMap = Collections.synchronizedMap(new LRUCache());
    private volatile boolean listenerRegistered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataProducer getContext(Class<?> arg0) {
        int endIdx;
        if (!arg0.equals(ODataProducer.class)) {
            return null;
        }
        String vdbName = null;
        String uri = this.uriInfo.getBaseUri().getRawPath();
        int idx = uri.indexOf("/odata/");
        vdbName = idx != -1 ? ((endIdx = uri.indexOf(47, idx + 7)) == -1 ? uri.substring(idx + 7) : uri.substring(idx + 7, endIdx)) : this.getInitParameters().getProperty("allow-vdb");
        VDBKey key = new VDBKey(vdbName, null);
        if (vdbName == null || !vdbName.matches("[\\w-\\.]+") || key.isAtMost() && key.getVersion() != null) {
            return new TeiidProducer(new LocalClient(vdbName, key.getVersion(), this.getInitParameters()));
        }
        if (key.getVersion() == null) {
            key = new VDBKey(vdbName, (Object)"1");
        }
        SoftReference<LocalClient> ref = this.clientMap.get(key);
        LocalClient client = null;
        if (ref != null) {
            client = ref.get();
        }
        if (client == null) {
            client = new LocalClient(key.getName(), key.getVersion(), this.getInitParameters());
            if (!this.listenerRegistered) {
                TeiidProducerProvider teiidProducerProvider = this;
                synchronized (teiidProducerProvider) {
                    if (!this.listenerRegistered) {
                        ConnectionImpl connection = null;
                        try {
                            connection = client.getConnection();
                            LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                            lsc.addListener((VDBLifeCycleListener)this);
                            this.listenerRegistered = true;
                        }
                        catch (SQLException e) {
                            LogManager.logWarning((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16014, new Object[0]));
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                        }
                    }
                }
            }
            ref = new SoftReference<LocalClient>(client);
            this.clientMap.put(key, ref);
        }
        return new TeiidProducer(client);
    }

    Properties getInitParameters() {
        Properties props = new Properties();
        Enumeration en = this.context.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            props.setProperty(key, this.context.getInitParameter(key));
        }
        return props;
    }

    public void removed(String name, CompositeVDB vdb) {
        this.clientMap.remove(vdb.getVDBKey());
    }

    public void finishedDeployment(String name, CompositeVDB vdb) {
        this.clientMap.remove(vdb.getVDBKey());
    }

    public void beforeRemove(String name, CompositeVDB vdb) {
    }

    public void added(String name, CompositeVDB vdb) {
    }
}

