/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmNonSimpleType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmType;

public class EdmCollectionType
extends EdmNonSimpleType {
    private final EdmType itemType;
    private final EdmProperty.CollectionKind collectionKind;

    public EdmCollectionType(EdmProperty.CollectionKind kind, EdmType itemType) {
        super(EdmCollectionType.getCollectionTypeString(kind, itemType));
        if (itemType == null) {
            throw new IllegalArgumentException("itemType cannot be null");
        }
        this.itemType = itemType;
        this.collectionKind = kind;
    }

    public EdmProperty.CollectionKind getCollectionKind() {
        return this.collectionKind;
    }

    public EdmType getItemType() {
        return this.itemType;
    }

    public static String getCollectionTypeString(EdmProperty.CollectionKind kind, EdmType itemType) {
        return kind.toString() + "(" + itemType.getFullyQualifiedTypeName() + ")";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends EdmType.Builder<EdmCollectionType, Builder> {
        private EdmProperty.CollectionKind kind;
        private EdmType.Builder<?, ?> collectionType;

        @Override
        Builder newBuilder(EdmCollectionType type, EdmItem.BuilderContext context) {
            this.kind = type.getCollectionKind();
            return this;
        }

        public Builder setKind(EdmProperty.CollectionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder setCollectionType(EdmType.Builder<?, ?> collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        @Override
        public EdmCollectionType build() {
            return (EdmCollectionType)this._build();
        }

        @Override
        protected EdmType buildImpl() {
            return new EdmCollectionType(this.kind, this.collectionType.build());
        }
    }
}

