/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.math.BigDecimal;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.OAtomEntity;
import org.odata4j.core.OAtomStreamEntity;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OEntity;
import org.odata4j.core.OLink;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperty;
import org.odata4j.core.ORelatedEntitiesLinkInline;
import org.odata4j.core.ORelatedEntityLinkInline;
import org.odata4j.core.OSimpleObject;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.internal.InternalUtil;
import org.odata4j.repack.org.apache.commons.codec.binary.Base64;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.XMLWriter2;

public class XmlFormatWriter {
    protected static final String edmx = "http://schemas.microsoft.com/ado/2007/06/edmx";
    protected static final String d = "http://schemas.microsoft.com/ado/2007/08/dataservices";
    protected static final String m = "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata";
    protected static final String edm = "http://schemas.microsoft.com/ado/2006/04/edm";
    protected static final String atom = "http://www.w3.org/2005/Atom";
    protected static final String app = "http://www.w3.org/2007/app";
    protected static final String scheme = "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme";
    public static final String related = "http://schemas.microsoft.com/ado/2007/08/dataservices/related/";
    public static final String atom_feed_content_type = "application/atom+xml;type=feed";
    public static final String atom_entry_content_type = "application/atom+xml;type=entry";

    protected void writeProperties(XMLWriter2 writer, List<OProperty<?>> properties) {
        for (OProperty<?> prop : properties) {
            this.writeProperty(writer, prop, false);
        }
    }

    protected void writeProperty(XMLWriter2 writer, OProperty<?> prop, boolean isDocumentElement) {
        this.writeProperty(writer, prop.getName(), prop.getType(), prop.getValue(), isDocumentElement, true);
    }

    protected void writeProperty(XMLWriter2 writer, String name, EdmType type, Object value, boolean isDocumentElement, boolean writeType) {
        writer.startElement(new QName2(d, name, "d"));
        if (isDocumentElement) {
            writer.writeNamespace("m", m);
            writer.writeNamespace("d", d);
        }
        String sValue = null;
        if (!type.isSimple()) {
            if (writeType) {
                String typename = type.getFullyQualifiedTypeName();
                if (value instanceof OCollection) {
                    EdmCollectionType collectionType = (EdmCollectionType)type;
                    typename = "Collection(" + collectionType.getItemType().getFullyQualifiedTypeName() + ")";
                }
                writer.writeAttribute(new QName2(m, "type", "m"), typename);
            }
            if (value instanceof OCollection) {
                this.writeCollection(writer, name, (OCollection)value);
            } else if (value instanceof OComplexObject) {
                this.writeProperties(writer, ((OComplexObject)value).getProperties());
            } else {
                List complexProperties = (List)value;
                if (complexProperties != null) {
                    this.writeProperties(writer, complexProperties);
                }
            }
        } else {
            if (writeType && type != EdmSimpleType.STRING) {
                writer.writeAttribute(new QName2(m, "type", "m"), type.getFullyQualifiedTypeName());
            }
            if (type == EdmSimpleType.INT32) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.INT16) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.INT64) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.BOOLEAN) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.BYTE) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.SBYTE) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.DECIMAL) {
                if (value != null) {
                    sValue = ((BigDecimal)value).toPlainString();
                }
            } else if (type == EdmSimpleType.SINGLE) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.DOUBLE) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.STRING) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.DATETIME) {
                if (value != null) {
                    sValue = InternalUtil.formatDateTimeForXml((LocalDateTime)value);
                }
            } else if (type == EdmSimpleType.BINARY) {
                byte[] bValue = (byte[])value;
                if (value != null) {
                    sValue = Base64.encodeBase64String(bValue);
                }
            } else if (type == EdmSimpleType.GUID) {
                if (value != null) {
                    sValue = value.toString();
                }
            } else if (type == EdmSimpleType.TIME) {
                if (value != null) {
                    sValue = InternalUtil.formatTimeForXml((LocalTime)value);
                }
            } else if (type == EdmSimpleType.DATETIMEOFFSET) {
                if (value != null) {
                    sValue = InternalUtil.formatDateTimeOffsetForXml((DateTime)value);
                }
            } else {
                throw new UnsupportedOperationException("Implement " + type);
            }
        }
        if (value == null) {
            writer.writeAttribute(new QName2(m, "null", "m"), "true");
        } else if (sValue != null) {
            writer.writeText(sValue);
        }
        writer.endElement(name);
    }

    private OAtomEntity getAtomInfo(OEntity oe) {
        OAtomEntity atomEntity;
        if (oe != null && (atomEntity = oe.findExtension(OAtomEntity.class)) != null) {
            return atomEntity;
        }
        return new OAtomEntity(){

            @Override
            public String getAtomEntityTitle() {
                return null;
            }

            @Override
            public String getAtomEntitySummary() {
                return null;
            }

            @Override
            public String getAtomEntityAuthor() {
                return null;
            }

            @Override
            public LocalDateTime getAtomEntityUpdated() {
                return null;
            }
        };
    }

    protected String writeEntry(XMLWriter2 writer, OEntity oe, List<OProperty<?>> entityProperties, List<OLink> entityLinks, String baseUri, String updated, EdmEntitySet ees, boolean isResponse) {
        OAtomStreamEntity stream;
        LocalDateTime updatedTime;
        String relid = null;
        String absid = null;
        if (isResponse) {
            relid = InternalUtil.getEntityRelId(oe);
            absid = baseUri + relid;
            this.writeElement(writer, "id", absid, new String[0]);
        }
        OAtomEntity oae = this.getAtomInfo(oe);
        this.writeElement(writer, "title", oae.getAtomEntityTitle(), "type", "text");
        String summary = oae.getAtomEntitySummary();
        if (summary != null) {
            this.writeElement(writer, "summary", summary, "type", "text");
        }
        if ((updatedTime = oae.getAtomEntityUpdated()) != null) {
            updated = InternalUtil.toString(updatedTime.toDateTime(DateTimeZone.UTC));
        }
        this.writeElement(writer, "updated", updated, new String[0]);
        writer.startElement("author");
        this.writeElement(writer, "name", oae.getAtomEntityAuthor(), new String[0]);
        writer.endElement("author");
        if (isResponse) {
            this.writeElement(writer, "link", null, "rel", "edit", "title", ees.getType().getName(), "href", relid);
        }
        if (entityLinks != null) {
            if (isResponse) {
                for (OLink link : entityLinks) {
                    String rel = related + link.getTitle();
                    String type = link.isCollection() ? atom_feed_content_type : atom_entry_content_type;
                    String href = relid + "/" + link.getTitle();
                    if (link.isInline()) {
                        writer.startElement("link");
                        writer.writeAttribute("rel", rel);
                        writer.writeAttribute("type", type);
                        writer.writeAttribute("title", link.getTitle());
                        writer.writeAttribute("href", href);
                        this.writeLinkInline(writer, link, href, baseUri, updated, isResponse);
                        writer.endElement("link");
                        continue;
                    }
                    this.writeElement(writer, "link", null, "rel", rel, "type", type, "title", link.getTitle(), "href", href);
                }
            } else {
                for (OLink olink : entityLinks) {
                    String type = olink.isCollection() ? atom_feed_content_type : atom_entry_content_type;
                    writer.startElement("link");
                    writer.writeAttribute("rel", olink.getRelation());
                    writer.writeAttribute("type", type);
                    writer.writeAttribute("title", olink.getTitle());
                    writer.writeAttribute("href", olink.getHref());
                    if (olink.isInline()) {
                        this.writeLinkInline(writer, olink, olink.getHref(), baseUri, updated, isResponse);
                    }
                    writer.endElement("link");
                }
            }
        }
        this.writeElement(writer, "category", null, "term", oe == null ? ees.getType().getFullyQualifiedTypeName() : oe.getEntityType().getFullyQualifiedTypeName(), "scheme", scheme);
        boolean hasStream = false;
        if (oe != null && (stream = oe.findExtension(OAtomStreamEntity.class)) != null) {
            hasStream = true;
            writer.startElement("content");
            writer.writeAttribute("type", stream.getAtomEntityType());
            writer.writeAttribute("src", baseUri + stream.getAtomEntitySource());
            writer.endElement("content");
        }
        if (!hasStream) {
            writer.startElement("content");
            writer.writeAttribute("type", "application/xml");
        }
        writer.startElement(new QName2(m, "properties", "m"));
        this.writeProperties(writer, entityProperties);
        writer.endElement("properties");
        if (!hasStream) {
            writer.endElement("content");
        }
        return absid;
    }

    protected void writeLinkInline(XMLWriter2 writer, OLink linkToInline, String href, String baseUri, String updated, boolean isResponse) {
        writer.startElement(new QName2(m, "inline", "m"));
        if (linkToInline instanceof ORelatedEntitiesLinkInline) {
            ORelatedEntitiesLinkInline relLink = (ORelatedEntitiesLinkInline)linkToInline;
            List<OEntity> entities = relLink.getRelatedEntities();
            if (entities != null && !entities.isEmpty()) {
                writer.startElement(new QName2("feed"));
                this.writeElement(writer, "title", linkToInline.getTitle(), "type", "text");
                this.writeElement(writer, "id", baseUri + href, new String[0]);
                this.writeElement(writer, "updated", updated, new String[0]);
                this.writeElement(writer, "link", null, "rel", "self", "title", linkToInline.getTitle(), "href", href);
                for (OEntity entity : ((ORelatedEntitiesLinkInline)linkToInline).getRelatedEntities()) {
                    writer.startElement("entry");
                    this.writeEntry(writer, entity, entity.getProperties(), entity.getLinks(), baseUri, updated, entity.getEntitySet(), isResponse);
                    writer.endElement("entry");
                }
                writer.endElement("feed");
            }
        } else if (linkToInline instanceof ORelatedEntityLinkInline) {
            OEntity entity = ((ORelatedEntityLinkInline)linkToInline).getRelatedEntity();
            if (entity != null) {
                writer.startElement("entry");
                this.writeEntry(writer, entity, entity.getProperties(), entity.getLinks(), baseUri, updated, entity.getEntitySet(), isResponse);
                writer.endElement("entry");
            }
        } else {
            throw new RuntimeException("Unknown OLink type " + linkToInline.getClass());
        }
        writer.endElement("inline");
    }

    protected void writeElement(XMLWriter2 writer, String elementName, String elementText, String ... attributes) {
        writer.startElement(elementName);
        for (int i = 0; i < attributes.length; i += 2) {
            writer.writeAttribute(attributes[i], attributes[i + 1]);
        }
        if (elementText != null) {
            writer.writeText(elementText);
        }
        writer.endElement(elementName);
    }

    private void writeCollection(XMLWriter2 writer, String name, OCollection<? extends OObject> c) {
        for (OObject oObject : c) {
            if (oObject instanceof OComplexObject) {
                this.writeProperty(writer, "element", oObject.getType(), oObject, false, false);
                continue;
            }
            if (oObject instanceof OSimpleObject) {
                this.writeProperty(writer, "element", oObject.getType(), ((OSimpleObject)oObject).getValue(), false, false);
                continue;
            }
            if (!(oObject instanceof OCollection)) continue;
            writer.startElement("d:element");
            writer.writeAttribute("m:type", "Collection(" + ((OCollection)oObject).getType().getFullyQualifiedTypeName() + ")");
            this.writeCollection(writer, "element", (OCollection)oObject);
            writer.endElement("d:element");
        }
    }
}

