/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.io.InputStream;
import java.util.Map;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public abstract class ServiceResponse {
    protected ServiceMetadata metadata;
    protected ODataResponse response;
    protected Map<String, String> preferences;
    private boolean closed;
    private boolean strictApplyPreferences = true;

    public ServiceResponse(ServiceMetadata metadata, ODataResponse response, Map<String, String> preferences) {
        this.metadata = metadata;
        this.response = response;
        this.preferences = preferences;
    }

    public ODataResponse getODataResponse() {
        return this.response;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void close() {
        if (!this.closed) {
            if (this.strictApplyPreferences && !this.preferences.isEmpty()) assert (this.response.getAllHeaders().get("Preference-Applied") != null);
            this.closed = true;
        }
    }

    public void writeNoContent(boolean closeResponse) {
        this.response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
        if (closeResponse) {
            this.close();
        }
    }

    public void writeNotFound(boolean closeResponse) {
        this.response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
        if (closeResponse) {
            this.close();
        }
    }

    public void writeServerError(boolean closeResponse) {
        this.response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        if (closeResponse) {
            this.close();
        }
    }

    public void writeBadRequest(boolean closeResponse) {
        this.response.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        if (closeResponse) {
            this.close();
        }
    }

    public void writeOK(ContentType contentType) {
        this.response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        this.response.setHeader("Content-Type", contentType.toContentTypeString());
    }

    public void writeHeader(String key, String value) {
        if ("Preference-Applied".equals(key)) {
            String previous = this.response.getHeader(key);
            if (previous != null) {
                value = previous + ";" + value;
            }
            this.response.setHeader(key, value);
        } else {
            this.response.setHeader(key, value);
        }
    }

    public void writeContent(InputStream content, int statusCode, boolean closeResponse) {
        this.response.setContent(content);
        this.response.setStatusCode(statusCode);
        if (closeResponse) {
            this.close();
        }
    }

    public void setStrictlyApplyPreferences(boolean flag) {
        this.strictApplyPreferences = flag;
    }

    public abstract void accepts(ServiceResponseVisior var1) throws ODataLibraryException, ODataApplicationException;
}

