/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.List;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmEntityContainer;
import org.apache.olingo.server.api.edm.provider.ActionImport;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityContainer;
import org.apache.olingo.server.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.server.api.edm.provider.EntitySet;
import org.apache.olingo.server.api.edm.provider.FunctionImport;
import org.apache.olingo.server.api.edm.provider.Singleton;
import org.apache.olingo.server.core.edm.provider.EdmActionImportImpl;
import org.apache.olingo.server.core.edm.provider.EdmEntitySetImpl;
import org.apache.olingo.server.core.edm.provider.EdmFunctionImportImpl;
import org.apache.olingo.server.core.edm.provider.EdmSingletonImpl;

public class EdmEntityContainerImpl
extends AbstractEdmEntityContainer {
    private final EdmProvider provider;
    private EntityContainer container;

    public EdmEntityContainerImpl(Edm edm, EdmProvider provider, EntityContainerInfo entityContainerInfo) {
        super(edm, entityContainerInfo.getContainerName(), entityContainerInfo.getExtendsContainer());
        this.provider = provider;
    }

    public EdmEntityContainerImpl(Edm edm, EdmProvider provider, FullQualifiedName containerFQN, EntityContainer entityContainer) {
        super(edm, containerFQN, entityContainer.getExtendsContainer());
        this.provider = provider;
        this.container = entityContainer;
    }

    protected EdmSingleton createSingleton(String singletonName) {
        EdmSingletonImpl singleton = null;
        try {
            Singleton providerSingleton = this.provider.getSingleton(this.entityContainerName, singletonName);
            if (providerSingleton != null) {
                singleton = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, providerSingleton);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return singleton;
    }

    protected EdmEntitySet createEntitySet(String entitySetName) {
        EdmEntitySetImpl entitySet = null;
        try {
            EntitySet providerEntitySet = this.provider.getEntitySet(this.entityContainerName, entitySetName);
            if (providerEntitySet != null) {
                entitySet = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, providerEntitySet);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return entitySet;
    }

    protected EdmActionImport createActionImport(String actionImportName) {
        EdmActionImportImpl actionImport = null;
        try {
            ActionImport providerImport = this.provider.getActionImport(this.entityContainerName, actionImportName);
            if (providerImport != null) {
                actionImport = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return actionImport;
    }

    protected EdmFunctionImport createFunctionImport(String functionImportName) {
        EdmFunctionImportImpl functionImport = null;
        try {
            FunctionImport providerImport = this.provider.getFunctionImport(this.entityContainerName, functionImportName);
            if (providerImport != null) {
                functionImport = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, providerImport);
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return functionImport;
    }

    protected void loadAllEntitySets() {
        this.loadContainer();
        List providerEntitySets = this.container.getEntitySets();
        if (providerEntitySets != null) {
            for (EntitySet entitySet : providerEntitySets) {
                if (this.entitySets.containsKey(entitySet.getName())) continue;
                EdmEntitySetImpl impl = new EdmEntitySetImpl(this.edm, (EdmEntityContainer)this, entitySet);
                this.entitySets.put(impl.getName(), impl);
            }
        }
    }

    protected void loadAllFunctionImports() {
        this.loadContainer();
        List providerFuctionImports = this.container.getFunctionImports();
        if (providerFuctionImports != null) {
            for (FunctionImport functionImport : providerFuctionImports) {
                String functionName = functionImport.getName();
                if (this.functionImports.containsKey(functionName)) continue;
                EdmFunctionImportImpl impl = new EdmFunctionImportImpl(this.edm, (EdmEntityContainer)this, functionImport);
                this.functionImports.put(functionName, impl);
            }
        }
    }

    protected void loadAllSingletons() {
        this.loadContainer();
        List providerSingletons = this.container.getSingletons();
        if (providerSingletons != null) {
            for (Singleton singleton : providerSingletons) {
                if (this.singletons.containsKey(singleton.getName())) continue;
                EdmSingletonImpl impl = new EdmSingletonImpl(this.edm, (EdmEntityContainer)this, singleton);
                this.singletons.put(singleton.getName(), impl);
            }
        }
    }

    protected void loadAllActionImports() {
        this.loadContainer();
        List providerActionImports = this.container.getActionImports();
        if (providerActionImports != null) {
            for (ActionImport actionImport : providerActionImports) {
                if (this.actionImports.containsKey(actionImport.getName())) continue;
                EdmActionImportImpl impl = new EdmActionImportImpl(this.edm, (EdmEntityContainer)this, actionImport);
                this.actionImports.put(actionImport.getName(), impl);
            }
        }
    }

    private void loadContainer() {
        if (this.container == null) {
            try {
                this.container = this.provider.getEntityContainer();
                if (this.container == null) {
                    this.container = new EntityContainer().setName(this.getName());
                }
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

