/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmStructuredTypeHelper;
import org.apache.olingo.server.api.edm.provider.NavigationProperty;
import org.apache.olingo.server.api.edm.provider.Property;
import org.apache.olingo.server.api.edm.provider.StructuredType;
import org.apache.olingo.server.core.edm.provider.EdmNavigationPropertyImpl;
import org.apache.olingo.server.core.edm.provider.EdmPropertyImpl;

public class EdmStructuredTypeHelperImpl
implements EdmStructuredTypeHelper {
    private final Edm edm;
    private final FullQualifiedName structuredTypeName;
    private final StructuredType structuredType;
    private Map<String, EdmProperty> properties;
    private Map<String, EdmNavigationProperty> navigationProperties;

    public EdmStructuredTypeHelperImpl(Edm edm, FullQualifiedName structuredTypeName, StructuredType structuredType) {
        this.edm = edm;
        this.structuredTypeName = structuredTypeName;
        this.structuredType = structuredType;
    }

    public Map<String, EdmProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, EdmProperty>();
            if (this.structuredType.getProperties() != null) {
                for (Property property : this.structuredType.getProperties()) {
                    this.properties.put(property.getName(), (EdmProperty)new EdmPropertyImpl(this.edm, this.structuredTypeName, property));
                }
            }
        }
        return this.properties;
    }

    public Map<String, EdmNavigationProperty> getNavigationProperties() {
        if (this.navigationProperties == null) {
            this.navigationProperties = new LinkedHashMap<String, EdmNavigationProperty>();
            if (this.structuredType.getNavigationProperties() != null) {
                for (NavigationProperty navigationProperty : this.structuredType.getNavigationProperties()) {
                    this.navigationProperties.put(navigationProperty.getName(), (EdmNavigationProperty)new EdmNavigationPropertyImpl(this.edm, this.structuredTypeName, navigationProperty));
                }
            }
        }
        return this.navigationProperties;
    }

    public boolean isOpenType() {
        return this.structuredType.isOpenType();
    }

    public boolean isAbstract() {
        return this.structuredType.isAbstract();
    }
}

