/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;

public abstract class AbstractEdmStructuredType
extends EdmTypeImpl
implements EdmStructuredType {
    protected EdmStructuredType baseType;
    protected FullQualifiedName baseTypeName;
    private List<String> propertyNames;
    private List<String> navigationPropertyNames;

    public AbstractEdmStructuredType(Edm edm, FullQualifiedName typeName, EdmTypeKind kind, FullQualifiedName baseTypeName) {
        super(edm, typeName, kind);
        this.baseTypeName = baseTypeName;
    }

    protected abstract EdmStructuredType buildBaseType(FullQualifiedName var1);

    protected abstract Map<String, EdmProperty> getProperties();

    protected abstract Map<String, EdmNavigationProperty> getNavigationProperties();

    protected abstract void checkBaseType();

    public List<String> getPropertyNames() {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
            this.checkBaseType();
            if (this.baseType != null) {
                this.propertyNames.addAll(this.baseType.getPropertyNames());
            }
            this.propertyNames.addAll(this.getProperties().keySet());
        }
        return this.propertyNames;
    }

    public List<String> getNavigationPropertyNames() {
        if (this.navigationPropertyNames == null) {
            this.navigationPropertyNames = new ArrayList<String>();
            this.checkBaseType();
            if (this.baseType != null) {
                this.navigationPropertyNames.addAll(this.baseType.getNavigationPropertyNames());
            }
            this.navigationPropertyNames.addAll(this.getNavigationProperties().keySet());
        }
        return this.navigationPropertyNames;
    }

    public EdmElement getProperty(String name) {
        EdmProperty property = this.getStructuralProperty(name);
        if (property == null) {
            property = this.getNavigationProperty(name);
        }
        return property;
    }

    public EdmProperty getStructuralProperty(String name) {
        EdmProperty property = null;
        this.checkBaseType();
        if (this.baseType != null) {
            property = this.baseType.getStructuralProperty(name);
        }
        if (property == null) {
            property = this.getProperties().get(name);
        }
        return property;
    }

    public EdmNavigationProperty getNavigationProperty(String name) {
        EdmNavigationProperty property = null;
        this.checkBaseType();
        if (this.baseType != null) {
            property = this.baseType.getNavigationProperty(name);
        }
        if (property == null) {
            property = this.getNavigationProperties().get(name);
        }
        return property;
    }

    public boolean compatibleTo(EdmType targetType) {
        AbstractEdmStructuredType sourceType = this;
        if (targetType == null) {
            throw new EdmException("Target type must not be null");
        }
        while (!sourceType.getName().equals(targetType.getName()) || !sourceType.getNamespace().equals(targetType.getNamespace())) {
            if ((sourceType = sourceType.getBaseType()) != null) continue;
            return false;
        }
        return true;
    }

    public String getAnnotationsTargetPath() {
        return null;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.getFullQualifiedName();
    }
}

