/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.serialization.ODataSerializer;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;
import org.apache.olingo.commons.core.data.AbstractODataObject;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.serialization.AbstractAtomDealer;
import org.apache.olingo.commons.core.serialization.AtomGeoValueSerializer;
import org.apache.olingo.commons.core.serialization.ContextURLParser;

public class AtomSerializer
extends AbstractAtomDealer
implements ODataSerializer {
    private static final XMLOutputFactory FACTORY = new OutputFactoryImpl();
    private final AtomGeoValueSerializer geoSerializer = new AtomGeoValueSerializer();
    private final boolean serverMode;

    public AtomSerializer(ODataServiceVersion version) {
        this(version, false);
    }

    public AtomSerializer(ODataServiceVersion version, boolean serverMode) {
        super(version);
        this.serverMode = serverMode;
    }

    private void collection(XMLStreamWriter writer, ValueType valueType, EdmPrimitiveTypeKind kind, List<?> value) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Object item : value) {
            if (this.version.compareTo((Enum)ODataServiceVersion.V40) < 0) {
                writer.writeStartElement("d", "element", this.namespaceData);
            } else {
                writer.writeStartElement("m", "element", this.namespaceMetadata);
            }
            this.value(writer, valueType, kind, item);
            writer.writeEndElement();
        }
    }

    private void value(XMLStreamWriter writer, ValueType valueType, EdmPrimitiveTypeKind kind, Object value) throws XMLStreamException, EdmPrimitiveTypeException {
        if (value == null) {
            writer.writeAttribute("m", this.namespaceMetadata, "null", Boolean.TRUE.toString());
            return;
        }
        switch (valueType) {
            case PRIMITIVE: {
                writer.writeCharacters(kind == null ? value.toString() : EdmPrimitiveTypeFactory.getInstance(kind).valueToString(value, null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null));
                break;
            }
            case ENUM: {
                writer.writeCharacters(value.toString());
                break;
            }
            case GEOSPATIAL: {
                this.geoSerializer.serialize(writer, (Geospatial)value);
                break;
            }
            case COLLECTION_PRIMITIVE: 
            case COLLECTION_GEOSPATIAL: 
            case COLLECTION_ENUM: 
            case COLLECTION_COMPLEX: 
            case COLLECTION_LINKED_COMPLEX: {
                this.collection(writer, valueType.getBaseType(), kind, (List)value);
                break;
            }
            case LINKED_COMPLEX: {
                for (Property property : ((LinkedComplexValue)value).getValue()) {
                    this.property(writer, property, false);
                }
                break;
            }
            case COMPLEX: {
                for (Property property : (List)value) {
                    this.property(writer, property, false);
                }
                break;
            }
        }
    }

    public void property(XMLStreamWriter writer, Property property, boolean standalone) throws XMLStreamException, EdmPrimitiveTypeException {
        if (this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 && standalone) {
            writer.writeStartElement("m", "value", this.namespaceData);
        } else {
            writer.writeStartElement("d", property.getName(), this.namespaceData);
        }
        if (standalone) {
            this.namespaces(writer);
        }
        EdmTypeInfo typeInfo = null;
        if (StringUtils.isNotBlank((CharSequence)property.getType())) {
            typeInfo = new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build();
            if (!EdmPrimitiveTypeKind.String.getFullQualifiedName().toString().equals(typeInfo.internal())) {
                writer.writeAttribute("m", this.namespaceMetadata, "type", typeInfo.external(this.version));
            }
        }
        this.value(writer, property.getValueType(), typeInfo == null ? null : typeInfo.getPrimitiveTypeKind(), property.getValue());
        if (!property.isNull() && property.isLinkedComplex()) {
            this.links(writer, property.asLinkedComplex().getAssociationLinks());
            this.links(writer, property.asLinkedComplex().getNavigationLinks());
        }
        writer.writeEndElement();
        for (Annotation annotation : property.getAnnotations()) {
            this.annotation(writer, annotation, property.getName());
        }
    }

    private void property(XMLStreamWriter writer, Property property) throws XMLStreamException, EdmPrimitiveTypeException {
        this.property(writer, property, true);
    }

    private void startDocument(XMLStreamWriter writer, String rootElement) throws XMLStreamException {
        writer.writeStartDocument();
        writer.setDefaultNamespace("http://www.w3.org/2005/Atom");
        writer.writeStartElement(rootElement);
        this.namespaces(writer);
    }

    private void property(Writer outWriter, Property property) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        writer.writeStartDocument();
        this.property(writer, property);
        writer.writeEndDocument();
        writer.flush();
    }

    private void links(XMLStreamWriter writer, List<Link> links) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Link link : links) {
            writer.writeStartElement("link");
            if (StringUtils.isNotBlank((CharSequence)link.getRel())) {
                writer.writeAttribute("rel", link.getRel());
            }
            if (StringUtils.isNotBlank((CharSequence)link.getTitle())) {
                writer.writeAttribute("title", link.getTitle());
            }
            if (StringUtils.isNotBlank((CharSequence)link.getHref())) {
                writer.writeAttribute("href", link.getHref());
            }
            if (StringUtils.isNotBlank((CharSequence)link.getType())) {
                writer.writeAttribute("type", link.getType());
            }
            if (link.getInlineEntity() != null || link.getInlineEntitySet() != null) {
                writer.writeStartElement("m", "inline", this.namespaceMetadata);
                if (link.getInlineEntity() != null) {
                    writer.writeStartElement("entry");
                    this.entity(writer, link.getInlineEntity());
                    writer.writeEndElement();
                }
                if (link.getInlineEntitySet() != null) {
                    writer.writeStartElement("feed");
                    this.entitySet(writer, link.getInlineEntitySet());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            for (Annotation annotation : link.getAnnotations()) {
                this.annotation(writer, annotation, null);
            }
            writer.writeEndElement();
        }
    }

    private void common(XMLStreamWriter writer, AbstractODataObject object) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)object.getTitle())) {
            writer.writeStartElement("title");
            writer.writeAttribute("type", "text");
            writer.writeCharacters(object.getTitle());
            writer.writeEndElement();
        }
    }

    private void properties(XMLStreamWriter writer, List<Property> properties) throws XMLStreamException, EdmPrimitiveTypeException {
        for (Property property : properties) {
            this.property(writer, property, false);
        }
    }

    private void annotation(XMLStreamWriter writer, Annotation annotation, String target) throws XMLStreamException, EdmPrimitiveTypeException {
        writer.writeStartElement("m", "annotation", this.namespaceMetadata);
        writer.writeAttribute("term", annotation.getTerm());
        if (target != null) {
            writer.writeAttribute("target", target);
        }
        EdmTypeInfo typeInfo = null;
        if (StringUtils.isNotBlank((CharSequence)annotation.getType())) {
            typeInfo = new EdmTypeInfo.Builder().setTypeExpression(annotation.getType()).build();
            if (!EdmPrimitiveTypeKind.String.getFullQualifiedName().toString().equals(typeInfo.internal())) {
                writer.writeAttribute("m", this.namespaceMetadata, "type", typeInfo.external(this.version));
            }
        }
        this.value(writer, annotation.getValueType(), typeInfo == null ? null : typeInfo.getPrimitiveTypeKind(), annotation.getValue());
        writer.writeEndElement();
    }

    private void entity(XMLStreamWriter writer, Entity entity) throws XMLStreamException, EdmPrimitiveTypeException {
        if (entity.getBaseURI() != null) {
            writer.writeAttribute("http://www.w3.org/XML/1998/namespace", "base", entity.getBaseURI().toASCIIString());
        }
        if (this.serverMode && StringUtils.isNotBlank((CharSequence)entity.getETag())) {
            writer.writeAttribute(this.namespaceMetadata, "etag", entity.getETag());
        }
        if (entity.getId() != null) {
            writer.writeStartElement("id");
            writer.writeCharacters(entity.getId().toASCIIString());
            writer.writeEndElement();
        }
        writer.writeStartElement("category");
        writer.writeAttribute("scheme", this.version.getNamespace(ODataServiceVersion.NamespaceKey.SCHEME));
        if (StringUtils.isNotBlank((CharSequence)entity.getType())) {
            writer.writeAttribute("term", new EdmTypeInfo.Builder().setTypeExpression(entity.getType()).build().external(this.version));
        }
        writer.writeEndElement();
        if (entity instanceof AbstractODataObject) {
            this.common(writer, (AbstractODataObject)entity);
        }
        if (this.serverMode) {
            if (entity.getEditLink() != null) {
                this.links(writer, Collections.singletonList(entity.getEditLink()));
            }
            if (entity.getSelfLink() != null) {
                this.links(writer, Collections.singletonList(entity.getSelfLink()));
            }
        }
        this.links(writer, entity.getAssociationLinks());
        this.links(writer, entity.getNavigationLinks());
        this.links(writer, entity.getMediaEditLinks());
        if (this.serverMode) {
            for (ODataOperation operation : entity.getOperations()) {
                writer.writeStartElement(this.namespaceMetadata, "action");
                writer.writeAttribute("metadata", operation.getMetadataAnchor());
                writer.writeAttribute("title", operation.getTitle());
                writer.writeAttribute("target", operation.getTarget().toASCIIString());
                writer.writeEndElement();
            }
        }
        writer.writeStartElement("content");
        if (entity.isMediaEntity()) {
            if (StringUtils.isNotBlank((CharSequence)entity.getMediaContentType())) {
                writer.writeAttribute("type", entity.getMediaContentType());
            }
            if (entity.getMediaContentSource() != null) {
                writer.writeAttribute("src", entity.getMediaContentSource().toASCIIString());
            }
            writer.writeEndElement();
            writer.writeStartElement(this.namespaceMetadata, "properties");
            this.properties(writer, entity.getProperties());
        } else {
            writer.writeAttribute("type", ContentType.APPLICATION_XML.toContentTypeString());
            writer.writeStartElement(this.namespaceMetadata, "properties");
            this.properties(writer, entity.getProperties());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        for (Annotation annotation : entity.getAnnotations()) {
            this.annotation(writer, annotation, null);
        }
    }

    private void entityRef(XMLStreamWriter writer, Entity entity) throws XMLStreamException {
        writer.writeStartElement("ref");
        writer.writeNamespace("", this.namespaceMetadata);
        writer.writeAttribute("id", entity.getId().toASCIIString());
    }

    private void entityRef(XMLStreamWriter writer, ResWrap<Entity> container) throws XMLStreamException {
        writer.writeStartElement("ref");
        writer.writeNamespace("", this.namespaceMetadata);
        this.addContextInfo(writer, container);
        writer.writeAttribute("id", ((Entity)container.getPayload()).getId().toASCIIString());
    }

    private void entity(Writer outWriter, Entity entity) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        if (entity.getType() == null && entity.getProperties().isEmpty()) {
            writer.writeStartDocument();
            writer.setDefaultNamespace(this.namespaceMetadata);
            this.entityRef(writer, entity);
        } else {
            this.startDocument(writer, "entry");
            this.entity(writer, entity);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void entity(Writer outWriter, ResWrap<Entity> container) throws XMLStreamException, EdmPrimitiveTypeException {
        Entity entity = (Entity)container.getPayload();
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        if (entity.getType() == null && entity.getProperties().isEmpty()) {
            writer.writeStartDocument();
            writer.setDefaultNamespace(this.namespaceMetadata);
            this.entityRef(writer, container);
        } else {
            this.startDocument(writer, "entry");
            this.addContextInfo(writer, container);
            this.entity(writer, entity);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void entitySet(XMLStreamWriter writer, EntitySet entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        if (entitySet.getBaseURI() != null) {
            writer.writeAttribute("http://www.w3.org/XML/1998/namespace", "base", entitySet.getBaseURI().toASCIIString());
        }
        if (entitySet.getCount() != null) {
            writer.writeStartElement(this.namespaceMetadata, "count");
            writer.writeCharacters(Integer.toString(entitySet.getCount()));
            writer.writeEndElement();
        }
        if (entitySet.getId() != null) {
            writer.writeStartElement("id");
            writer.writeCharacters(entitySet.getId().toASCIIString());
            writer.writeEndElement();
        }
        if (entitySet instanceof AbstractODataObject) {
            this.common(writer, (AbstractODataObject)entitySet);
        }
        for (Entity entity : entitySet.getEntities()) {
            if (entity.getType() == null && entity.getProperties().isEmpty()) {
                this.entityRef(writer, entity);
                writer.writeEndElement();
                continue;
            }
            writer.writeStartElement("entry");
            this.entity(writer, entity);
            writer.writeEndElement();
        }
        if (this.serverMode) {
            LinkImpl next;
            if (entitySet.getNext() != null) {
                next = new LinkImpl();
                next.setRel("next");
                next.setHref(entitySet.getNext().toASCIIString());
                this.links(writer, Collections.singletonList(next));
            }
            if (entitySet.getDeltaLink() != null) {
                next = new LinkImpl();
                next.setRel(ODataServiceVersion.V40.getNamespace(ODataServiceVersion.NamespaceKey.DELTA_LINK_REL));
                next.setHref(entitySet.getDeltaLink().toASCIIString());
                this.links(writer, Collections.singletonList(next));
            }
        }
    }

    private void entitySet(Writer outWriter, EntitySet entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        this.startDocument(writer, "feed");
        this.entitySet(writer, entitySet);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void entitySet(Writer outWriter, ResWrap<EntitySet> entitySet) throws XMLStreamException, EdmPrimitiveTypeException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        this.startDocument(writer, "feed");
        this.addContextInfo(writer, entitySet);
        this.entitySet(writer, (EntitySet)entitySet.getPayload());
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void link(Writer outWriter, Link link) throws XMLStreamException {
        XMLStreamWriter writer = FACTORY.createXMLStreamWriter(outWriter);
        writer.writeStartDocument();
        writer.writeStartElement("links");
        writer.writeDefaultNamespace(this.namespaceData);
        writer.writeStartElement("uri");
        writer.writeCharacters(link.getHref());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    public <T> void write(Writer writer, T obj) throws ODataSerializerException {
        try {
            if (obj instanceof EntitySet) {
                this.entitySet(writer, (EntitySet)obj);
            } else if (obj instanceof Entity) {
                this.entity(writer, (Entity)obj);
            } else if (obj instanceof Property) {
                this.property(writer, (Property)obj);
            } else if (obj instanceof Link) {
                this.link(writer, (Link)obj);
            }
        }
        catch (XMLStreamException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    public <T> void write(Writer writer, ResWrap<T> container) throws ODataSerializerException {
        Object obj = container == null ? null : container.getPayload();
        try {
            if (obj instanceof EntitySet) {
                this.entitySet(writer, container);
            } else if (obj instanceof Entity) {
                this.entity(writer, container);
            } else if (obj instanceof Property) {
                this.property(writer, (Property)obj);
            } else if (obj instanceof Link) {
                this.link(writer, (Link)obj);
            }
        }
        catch (XMLStreamException e) {
            throw new ODataSerializerException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new ODataSerializerException((Throwable)e);
        }
    }

    private <T> void addContextInfo(XMLStreamWriter writer, ResWrap<T> container) throws XMLStreamException {
        if (container.getContextURL() != null) {
            ContextURL contextURL = ContextURLParser.parse(container.getContextURL());
            String base = contextURL.getServiceRoot().toASCIIString();
            if (container.getPayload() instanceof EntitySet) {
                ((EntitySetImpl)container.getPayload()).setBaseURI(base);
            }
            if (container.getPayload() instanceof Entity) {
                ((EntityImpl)container.getPayload()).setBaseURI(base);
            }
            writer.writeAttribute(this.namespaceMetadata, "context", container.getContextURL().toASCIIString());
        }
        if (StringUtils.isNotBlank((CharSequence)container.getMetadataETag())) {
            writer.writeAttribute(this.namespaceMetadata, "metadata-etag", container.getMetadataETag());
        }
    }
}

