/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.core.data.DeletedEntityImpl;
import org.apache.olingo.commons.core.data.DeltaLinkImpl;
import org.apache.olingo.commons.core.data.v4.DeltaImpl;
import org.apache.olingo.commons.core.serialization.ContextURLParser;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonEntityDeserializer;

public class JsonDeltaDeserializer
extends JsonDeserializer {
    public JsonDeltaDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<Delta> doDeserialize(JsonParser parser) throws IOException {
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        DeltaImpl delta = new DeltaImpl();
        URI uRI = contextURL = tree.hasNonNull("@odata.context") ? URI.create(tree.get("@odata.context").textValue()) : null;
        if (contextURL != null) {
            delta.setBaseURI(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata"));
        }
        if (tree.hasNonNull(this.jsonCount)) {
            delta.setCount(tree.get(this.jsonCount).asInt());
        }
        if (tree.hasNonNull(this.jsonNextLink)) {
            delta.setNext(URI.create(tree.get(this.jsonNextLink).textValue()));
        }
        if (tree.hasNonNull(this.jsonDeltaLink)) {
            delta.setDeltaLink(URI.create(tree.get(this.jsonDeltaLink).textValue()));
        }
        if (tree.hasNonNull("value")) {
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.version, this.serverMode);
            for (JsonNode jsonNode : tree.get("value")) {
                ObjectNode item = (ObjectNode)jsonNode;
                ContextURL itemContextURL = item.hasNonNull("@odata.context") ? ContextURLParser.parse(URI.create(item.get("@odata.context").textValue())) : null;
                item.remove("@odata.context");
                if (itemContextURL == null || itemContextURL.isEntity()) {
                    delta.getEntities().add((Entity)entityDeserializer.doDeserialize(item.traverse(parser.getCodec())).getPayload());
                    continue;
                }
                if (itemContextURL.isDeltaDeletedEntity()) {
                    delta.getDeletedEntities().add((DeletedEntity)parser.getCodec().treeToValue((TreeNode)item, DeletedEntityImpl.class));
                    continue;
                }
                if (itemContextURL.isDeltaLink()) {
                    delta.getAddedLinks().add((DeltaLink)parser.getCodec().treeToValue((TreeNode)item, DeltaLinkImpl.class));
                    continue;
                }
                if (!itemContextURL.isDeltaDeletedLink()) continue;
                delta.getDeletedLinks().add((DeltaLink)parser.getCodec().treeToValue((TreeNode)item, DeltaLinkImpl.class));
            }
        }
        return new ResWrap(contextURL, null, (Object)delta);
    }

    public ResWrap<Delta> toDelta(InputStream input) throws ODataDeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper()).createParser(input);
            return this.doDeserialize(parser);
        }
        catch (IOException e) {
            throw new ODataDeserializerException((Throwable)e);
        }
    }
}

