/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.Alias;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.Enumeration;
import org.apache.olingo.server.api.uri.queryoption.expression.LambdaRef;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.Method;
import org.apache.olingo.server.api.uri.queryoption.expression.TypeLiteral;
import org.apache.olingo.server.api.uri.queryoption.expression.Unary;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.metadata.ForeignKey;
import org.teiid.olingo.LiteralParser;
import org.teiid.olingo.ODataExpressionVisitor;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataQueryContext;
import org.teiid.olingo.ODataSQLBuilder;
import org.teiid.olingo.ODataTypeManager;
import org.teiid.olingo.ResourcePropertyCollector;
import org.teiid.olingo.SQLParam;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class ODataExpressionToSQLVisitor
extends ODataExpressionVisitor {
    private final Stack<Expression> stack = new Stack();
    private final ODataQueryContext context;
    private final ArrayList<SQLParam> params = new ArrayList();
    private boolean prepared = false;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final UriInfo uriInfo;

    public ODataExpressionToSQLVisitor(ODataQueryContext context, boolean prepared, UriInfo info) {
        this.context = context;
        this.prepared = prepared;
        this.uriInfo = info;
    }

    public Expression getExpression(org.apache.olingo.server.api.uri.queryoption.expression.Expression expr) {
        this.accept(expr);
        return this.stack.pop();
    }

    @Override
    public void visit(Alias expr) {
        Object value = LiteralParser.parseLiteral(this.uriInfo.getValueForAlias(expr.getParameterName()));
        if (this.prepared) {
            this.stack.add((Expression)new Reference(this.params.size()));
            this.params.add(new SQLParam(value, JDBCSQLTypeInfo.getSQLTypeFromClass((String)value.getClass().getName())));
        } else {
            this.stack.add((Expression)new Constant(value));
        }
    }

    @Override
    public void visit(Binary expr) {
        this.accept(expr.getLeftOperand());
        Expression lhs = this.stack.pop();
        this.accept(expr.getRightOperand());
        Expression rhs = this.stack.pop();
        switch (expr.getOperator()) {
            case HAS: {
                break;
            }
            case MUL: {
                this.stack.push((Expression)new Function("*", new Expression[]{lhs, rhs}));
                break;
            }
            case DIV: {
                this.stack.push((Expression)new Function("/", new Expression[]{lhs, rhs}));
                break;
            }
            case MOD: {
                this.stack.push((Expression)new Function("MOD", new Expression[]{lhs, rhs}));
                break;
            }
            case ADD: {
                this.stack.push((Expression)new Function("+", new Expression[]{lhs, rhs}));
                break;
            }
            case SUB: {
                this.stack.push((Expression)new Function("-", new Expression[]{lhs, rhs}));
                break;
            }
            case GT: {
                this.stack.push((Expression)new CompareCriteria(lhs, 4, rhs));
                break;
            }
            case GE: {
                this.stack.push((Expression)new CompareCriteria(lhs, 6, rhs));
                break;
            }
            case LT: {
                this.stack.push((Expression)new CompareCriteria(lhs, 3, rhs));
                break;
            }
            case LE: {
                this.stack.push((Expression)new CompareCriteria(lhs, 5, rhs));
                break;
            }
            case EQ: {
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    this.stack.push((Expression)new IsNullCriteria(lhs));
                    break;
                }
                this.stack.push((Expression)new CompareCriteria(lhs, 1, rhs));
                break;
            }
            case NE: {
                if (rhs instanceof Constant && ((Constant)rhs).getType() == DataTypeManager.DefaultDataClasses.NULL) {
                    IsNullCriteria crit = new IsNullCriteria(lhs);
                    crit.setNegated(true);
                    this.stack.push((Expression)crit);
                    break;
                }
                this.stack.push((Expression)new CompareCriteria(lhs, 2, rhs));
                break;
            }
            case AND: {
                this.stack.push((Expression)new CompoundCriteria(0, (Criteria)lhs, (Criteria)rhs));
                break;
            }
            case OR: {
                this.stack.push((Expression)new CompoundCriteria(1, (Criteria)lhs, (Criteria)rhs));
            }
        }
    }

    @Override
    public void visit(Enumeration expr) {
        this.exceptions.add((Exception)new TeiidException("un supported option"));
    }

    @Override
    public void visit(LambdaRef expr) {
    }

    @Override
    public void visit(Literal expr) {
        Object value = LiteralParser.parseLiteral(expr.getText());
        if (this.prepared) {
            this.stack.add((Expression)new Reference(this.params.size()));
            this.params.add(new SQLParam(value, JDBCSQLTypeInfo.getSQLTypeFromClass((String)value.getClass().getName())));
        } else {
            this.stack.add((Expression)new Constant(value));
        }
    }

    @Override
    public void visit(Member expr) {
        ResourcePropertyCollector visitor = new ResourcePropertyCollector();
        visitor.visit(expr.getResourcePath());
        UriResource resource = visitor.getResource();
        if (resource.getKind() == UriResourceKind.primitiveProperty) {
            this.stack.add((Expression)new ElementSymbol(((UriResourceProperty)resource).getProperty().getName(), this.context.getEdmEntityTableGroup()));
        } else if (resource.getKind() == UriResourceKind.navigationProperty) {
            EdmNavigationProperty navigation = ((UriResourceNavigation)resource).getProperty();
            EdmEntityType type = navigation.getType();
            if (!visitor.isCount()) {
                this.exceptions.add((Exception)new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16028, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16028, new Object[0])));
            }
            GroupSymbol navGroup = new GroupSymbol(this.context.getNextAliasGroup(), type.getNamespace() + "." + type.getName());
            Query query = new Query();
            query.setSelect(new Select(Arrays.asList(new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null))));
            query.setFrom(new From(Arrays.asList(new UnaryFromClause(navGroup))));
            CompareCriteria criteria = null;
            for (ForeignKey fk : this.context.getEdmEntityTable().getForeignKeys()) {
                if (!fk.getName().equals(navigation.getName())) continue;
                List<String> lhsColumns = ODataSQLBuilder.getColumnNames(fk.getColumns());
                List rhsColumns = fk.getReferenceColumns();
                for (int i = 0; i < lhsColumns.size(); ++i) {
                    if (criteria == null) {
                        criteria = new CompareCriteria((Expression)new ElementSymbol(lhsColumns.get(i), this.context.getEdmEntityTableGroup()), 1, (Expression)new ElementSymbol((String)rhsColumns.get(i), navGroup));
                        continue;
                    }
                    CompareCriteria subcriteria = new CompareCriteria((Expression)new ElementSymbol(lhsColumns.get(i), this.context.getEdmEntityTableGroup()), 1, (Expression)new ElementSymbol((String)rhsColumns.get(i), navGroup));
                    criteria = new CompoundCriteria(0, (Criteria)criteria, (Criteria)subcriteria);
                }
            }
            query.setCriteria(criteria);
            this.stack.add((Expression)new ScalarSubquery((QueryCommand)query));
        }
    }

    @Override
    public void visit(Method expr) {
        ArrayList<Expression> teiidExprs = new ArrayList<Expression>();
        for (org.apache.olingo.server.api.uri.queryoption.expression.Expression exp : expr.getParameters()) {
            this.accept(exp);
            teiidExprs.add(this.stack.pop());
        }
        switch (expr.getMethod()) {
            case CONTAINS: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0), new Constant((Object)1)}), 6, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case STARTSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1), new Constant((Object)1)}), 1, (Expression)new Constant((Object)1));
                this.stack.push((Expression)criteria);
                break;
            }
            case ENDSWITH: {
                CompareCriteria criteria = new CompareCriteria((Expression)new Function("ENDSWITH", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}), 1, (Expression)new Constant((Object)Boolean.TRUE));
                this.stack.push((Expression)criteria);
                break;
            }
            case LENGTH: {
                this.stack.push((Expression)new Function("LENGTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case INDEXOF: {
                this.stack.push((Expression)new Function("LOCATE", new Expression[]{(Expression)teiidExprs.get(1), (Expression)teiidExprs.get(0)}));
                break;
            }
            case SUBSTRING: {
                this.stack.push((Expression)new Function("SUBSTRING", teiidExprs.toArray(new Expression[teiidExprs.size()])));
                break;
            }
            case TOLOWER: {
                this.stack.push((Expression)new Function("LCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TOUPPER: {
                this.stack.push((Expression)new Function("UCASE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case TRIM: {
                this.stack.push((Expression)new Function("TRIM", new Expression[]{new Constant((Object)"BOTH"), new Constant((Object)Character.valueOf(' ')), (Expression)teiidExprs.get(0)}));
                break;
            }
            case CONCAT: {
                this.stack.push((Expression)new Function("CONCAT2", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            case YEAR: {
                this.stack.push((Expression)new Function("YEAR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MONTH: {
                this.stack.push((Expression)new Function("MONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case DAY: {
                this.stack.push((Expression)new Function("DAYOFMONTH", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case HOUR: {
                this.stack.push((Expression)new Function("HOUR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case MINUTE: {
                this.stack.push((Expression)new Function("MINUTE", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case SECOND: {
                this.stack.push((Expression)new Function("SECOND", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case NOW: {
                this.stack.push((Expression)new Function("NOW", new Expression[0]));
                break;
            }
            case ROUND: {
                this.stack.push((Expression)new Function("ROUND", new Expression[]{(Expression)teiidExprs.get(0), new Constant((Object)0)}));
                break;
            }
            case FLOOR: {
                this.stack.push((Expression)new Function("FLOOR", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CEILING: {
                this.stack.push((Expression)new Function("CEILING", new Expression[]{(Expression)teiidExprs.get(0)}));
                break;
            }
            case CAST: {
                this.stack.push((Expression)new Function("CONVERT", new Expression[]{(Expression)teiidExprs.get(0), (Expression)teiidExprs.get(1)}));
                break;
            }
            default: {
                this.exceptions.add((Exception)new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16027, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16027, new Object[]{expr.getMethod()})));
            }
        }
    }

    @Override
    public void visit(TypeLiteral expr) {
        this.stack.push((Expression)new Constant((Object)ODataTypeManager.teiidType((SingletonPrimitiveType)expr.getType())));
    }

    @Override
    public void visit(Unary expr) {
        this.accept(expr.getOperand());
        Expression teiidExpr = this.stack.pop();
        switch (expr.getOperator()) {
            case MINUS: {
                this.stack.push((Expression)new Function("*", new Expression[]{new Constant((Object)-1), teiidExpr}));
                break;
            }
            case NOT: {
                this.stack.push((Expression)new NotCriteria((Criteria)new ExpressionCriteria(teiidExpr)));
            }
        }
    }
}

