/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.DefaultODataResourceURLHierarchyVisitor;
import org.teiid.olingo.ODataExpressionToSQLVisitor;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.ODataQueryContext;
import org.teiid.olingo.ProjectedColumn;
import org.teiid.olingo.ResourcePropertyCollector;
import org.teiid.olingo.SQLParam;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class ODataSQLBuilder
extends DefaultODataResourceURLHierarchyVisitor
implements ODataQueryContext {
    private final MetadataStore metadata;
    private boolean prepared = true;
    private final List<ProjectedColumn> projectedColumns = new ArrayList<ProjectedColumn>();
    private final ArrayList<SQLParam> params = new ArrayList();
    private final AtomicInteger groupCount = new AtomicInteger(1);
    private FromClause fromClause;
    private Criteria criteria;
    private final ArrayList<TeiidException> exceptions = new ArrayList();
    private EdmEntitySet edmEntitySet;
    private Table edmEntityTable;
    private GroupSymbol edmEntityTableGroup;
    private SkipOption skipOption;
    private TopOption topOption;
    private boolean countOption;
    private OrderBy orderBy;
    private boolean selectionComplete;

    public ODataSQLBuilder(MetadataStore metadata, boolean prepared) {
        this.metadata = metadata;
        this.prepared = prepared;
    }

    public EdmEntitySet getEntitySet() {
        return this.edmEntitySet;
    }

    @Override
    public Table getEdmEntityTable() {
        return this.edmEntityTable;
    }

    @Override
    public GroupSymbol getEdmEntityTableGroup() {
        return this.edmEntityTableGroup;
    }

    public boolean isCountQuery() {
        return this.countOption;
    }

    public Integer getSkip() {
        if (this.skipOption == null) {
            return null;
        }
        return this.skipOption.getValue();
    }

    public Integer getTop() {
        if (this.topOption == null) {
            return null;
        }
        return this.topOption.getValue();
    }

    public Query selectQuery(boolean countQuery) throws TeiidException {
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
        Select select = new Select();
        for (ProjectedColumn column : this.projectedColumns) {
            select.addSymbol(column.getExpression());
        }
        Query query = new Query();
        From from = new From();
        from.addClause(this.fromClause);
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria(this.criteria);
        if (countQuery) {
            AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
            select = new Select(Arrays.asList(aggregateSymbol));
            query.setSelect(select);
        } else if (this.topOption != null && this.skipOption != null) {
            query.setLimit(new Limit((Expression)new Constant((Object)this.skipOption.getValue()), (Expression)new Constant((Object)this.topOption.getValue())));
        } else if (this.topOption != null) {
            query.setLimit(new Limit((Expression)new Constant((Object)0), (Expression)new Constant((Object)this.topOption.getValue())));
        }
        if (this.orderBy != null & !countQuery) {
            query.setOrderBy(this.orderBy);
        }
        return query;
    }

    List<ProjectedColumn> getProjectedColumns() {
        return this.projectedColumns;
    }

    private Table findTable(EdmEntitySet entitySet, MetadataStore store) {
        return this.findTable(entitySet.getEntityType(), store);
    }

    private Table findTable(EdmEntityType entityType, MetadataStore store) {
        Schema schema = store.getSchema(entityType.getNamespace());
        return schema.getTable(entityType.getName());
    }

    private Column findColumn(Table table, String propertyName) {
        return table.getColumnByName(propertyName);
    }

    public List<SQLParam> getParameters() {
        return this.params;
    }

    @Override
    public void visit(UriResourceEntitySet info) {
        this.edmEntitySet = info.getEntitySet();
        this.edmEntityTable = this.findTable(this.edmEntitySet, this.metadata);
        this.edmEntityTableGroup = new GroupSymbol("g0", this.edmEntityTable.getFullName());
        this.fromClause = new UnaryFromClause(this.edmEntityTableGroup);
        if (info.getKeyPredicates() != null && !info.getKeyPredicates().isEmpty()) {
            List keys = info.getKeyPredicates();
            try {
                this.criteria = this.buildEntityKeyCriteria(this.edmEntityTable, this.edmEntityTableGroup, keys);
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
        }
    }

    private Criteria buildEntityKeyCriteria(Table table, GroupSymbol entityGroup, List<UriParameter> keys) throws TeiidException {
        KeyRecord pk = table.getPrimaryKey();
        if (keys.size() == 1) {
            if (pk.getColumns().size() != 1) {
                throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{table.getFullName()}));
            }
            Column column = (Column)table.getPrimaryKey().getColumns().get(0);
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this, false, this.getUriInfo());
            return new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityGroup), 1, visitor.getExpression(keys.get(0).getExpression()));
        }
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        if (pk.getColumns().size() != keys.size()) {
            throw new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16015, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16015, new Object[]{table.getFullName()}));
        }
        for (UriParameter key : keys) {
            Column column = this.findColumn(table, key.getName());
            ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this, false, this.getUriInfo());
            critList.add(new CompareCriteria((Expression)new ElementSymbol(column.getName(), entityGroup), 1, visitor.getExpression(key.getExpression())));
        }
        return new CompoundCriteria(0, critList);
    }

    @Override
    public void visit(SkipOption option) {
        this.skipOption = option;
    }

    @Override
    public void visit(TopOption option) {
        this.topOption = option;
    }

    @Override
    public void visit(CountOption info) {
        this.countOption = info.getValue();
    }

    @Override
    public void visit(SelectOption option) {
        if (this.selectionComplete) {
            return;
        }
        if (option == null) {
            this.addAllColumns();
        } else {
            for (SelectItem si : option.getSelectItems()) {
                if (si.isStar()) {
                    this.addAllColumns();
                    continue;
                }
                UriResource resource = ResourcePropertyCollector.getUriResource(si.getResourcePath());
                if (resource.getKind() != UriResourceKind.primitiveProperty) {
                    this.exceptions.add(new TeiidException((BundleUtil.Event)ODataPlugin.Event.TEIID16025, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16025, new Object[0])));
                    continue;
                }
                UriResourcePrimitiveProperty primitiveProp = (UriResourcePrimitiveProperty)resource;
                this.addSelectColumn((Expression)new ElementSymbol(primitiveProp.getProperty().getName(), this.edmEntityTableGroup));
            }
        }
    }

    private void addAllColumns() {
        for (Column column : this.edmEntityTable.getColumns()) {
            this.addSelectColumn((Expression)new ElementSymbol(column.getName(), this.edmEntityTableGroup));
        }
    }

    private void addSelectColumn(Expression expr) {
        this.addProjectedColumn(expr, true);
    }

    private void addProjectedColumn(final Expression expr, final boolean visibility) {
        int i = 0;
        for (i = 0; i < this.projectedColumns.size(); ++i) {
            ProjectedColumn pc = this.projectedColumns.get(i);
            if (!pc.getExpression().equals(expr)) continue;
            this.projectedColumns.remove(i);
            break;
        }
        this.projectedColumns.add(new ProjectedColumn(){

            @Override
            public Expression getExpression() {
                return expr;
            }

            @Override
            public boolean isVisible() {
                return visibility;
            }
        });
    }

    @Override
    public void visit(OrderByOption option) {
        this.orderBy = new OrderBy();
        if (option == null || option.getOrders().isEmpty()) {
            KeyRecord record = this.edmEntityTable.getPrimaryKey();
            if (record == null) {
                record = (KeyRecord)this.edmEntityTable.getUniqueKeys().get(0);
            }
            for (Column column : record.getColumns()) {
                ElementSymbol expr = new ElementSymbol(column.getName(), this.edmEntityTableGroup);
                this.orderBy.addVariable((Expression)expr);
                this.addProjectedColumn((Expression)expr, false);
            }
        } else {
            List orderBys = option.getOrders();
            for (OrderByItem orderby : orderBys) {
                ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this, false, this.getUriInfo());
                Expression expr = visitor.getExpression(orderby.getExpression());
                this.orderBy.addVariable(expr, !orderby.isDescending());
                this.addProjectedColumn(expr, false);
            }
        }
    }

    @Override
    public void visit(FilterOption info) {
        ODataExpressionToSQLVisitor visitor = new ODataExpressionToSQLVisitor(this, this.prepared, this.getUriInfo());
        this.criteria = (Criteria)visitor.getExpression(info.getExpression());
    }

    @Override
    public void visit(UriResourceNavigation info) {
        EdmNavigationProperty property = info.getProperty();
        String navigationName = property.getName();
        EdmEntityType type = property.getType();
        String aliasGroup = this.getNextAliasGroup();
        for (ForeignKey fk : this.edmEntityTable.getForeignKeys()) {
            if (!fk.getName().equals(navigationName)) continue;
            List<String> refColumns = fk.getReferenceColumns();
            if (refColumns == null) {
                refColumns = ODataSQLBuilder.getColumnNames(this.edmEntityTable.getPrimaryKey().getColumns());
            }
            Table joinTable = this.findTable(type, this.metadata);
            GroupSymbol joinGroup = new GroupSymbol(aliasGroup, joinTable.getFullName());
            List keys = info.getKeyPredicates();
            try {
                if (keys != null && keys.size() > 0) {
                    this.criteria = this.buildEntityKeyCriteria(joinTable, joinGroup, keys);
                    this.fromClause = new UnaryFromClause(joinGroup);
                } else {
                    this.fromClause = this.addJoinTable(JoinType.JOIN_INNER, joinGroup, this.edmEntityTableGroup, refColumns, ODataSQLBuilder.getColumnNames(fk.getColumns()));
                }
                this.edmEntityTableGroup = joinGroup;
                this.edmEntityTable = joinTable;
            }
            catch (TeiidException e) {
                this.exceptions.add(e);
            }
            break;
        }
    }

    @Override
    public String getNextAliasGroup() {
        String aliasGroup = "g" + this.groupCount.getAndIncrement();
        return aliasGroup;
    }

    private FromClause addJoinTable(JoinType joinType, GroupSymbol joinGroup, GroupSymbol entityGroup, List<String> pkColumns, List<String> refColumns) {
        ArrayList<CompareCriteria> critList = new ArrayList<CompareCriteria>();
        for (int i = 0; i < refColumns.size(); ++i) {
            critList.add(new CompareCriteria((Expression)new ElementSymbol(pkColumns.get(i), entityGroup), 1, (Expression)new ElementSymbol(refColumns.get(i), joinGroup)));
        }
        Criteria crit = (Criteria)critList.get(0);
        for (int i = 1; i < critList.size(); ++i) {
            crit = new CompoundCriteria(0, crit, (Criteria)critList.get(i));
        }
        return new JoinPredicate(this.fromClause, (FromClause)new UnaryFromClause(joinGroup), joinType, crit);
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    @Override
    public void visit(UriResourcePrimitiveProperty info) {
        this.addSelectColumn((Expression)new ElementSymbol(info.getProperty().getName(), this.edmEntityTableGroup));
        this.selectionComplete = true;
    }
}

