/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.edm.provider.Action;
import org.apache.olingo.server.api.edm.provider.ActionImport;
import org.apache.olingo.server.api.edm.provider.AliasInfo;
import org.apache.olingo.server.api.edm.provider.ComplexType;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityContainer;
import org.apache.olingo.server.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.server.api.edm.provider.EntitySet;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.EnumType;
import org.apache.olingo.server.api.edm.provider.Function;
import org.apache.olingo.server.api.edm.provider.FunctionImport;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.edm.provider.Singleton;
import org.apache.olingo.server.api.edm.provider.Term;
import org.apache.olingo.server.api.edm.provider.TypeDefinition;
import org.teiid.metadata.MetadataStore;

public class TeiidEdmProvider
extends EdmProvider {
    private final Schema edmSchema;
    private final MetadataStore metadataStore;

    public TeiidEdmProvider(MetadataStore metadataStore, Schema edmSchema) {
        this.edmSchema = edmSchema;
        this.metadataStore = metadataStore;
    }

    public EnumType getEnumType(FullQualifiedName enumTypeName) throws ODataException {
        return super.getEnumType(enumTypeName);
    }

    public TypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) throws ODataException {
        return super.getTypeDefinition(typeDefinitionName);
    }

    public List<Function> getFunctions(FullQualifiedName fqn) throws ODataException {
        return this.edmSchema.getFunctions();
    }

    public Term getTerm(FullQualifiedName termName) throws ODataException {
        return super.getTerm(termName);
    }

    public EntitySet getEntitySet(FullQualifiedName fqn, String entitySetName) throws ODataException {
        EntityContainer ec = this.edmSchema.getEntityContainer();
        if (ec.getEntitySets() != null) {
            for (EntitySet es : ec.getEntitySets()) {
                if (!es.getName().equals(entitySetName)) continue;
                return es;
            }
        }
        return null;
    }

    public Singleton getSingleton(FullQualifiedName fqn, String singletonName) throws ODataException {
        EntityContainer ec = this.edmSchema.getEntityContainer();
        if (ec.getSingletons() != null) {
            for (Singleton es : ec.getSingletons()) {
                if (!es.getName().equals(singletonName)) continue;
                return es;
            }
        }
        return null;
    }

    public ActionImport getActionImport(FullQualifiedName fqn, String actionImportName) throws ODataException {
        EntityContainer ec = this.edmSchema.getEntityContainer();
        if (ec.getActionImports() != null) {
            for (ActionImport es : ec.getActionImports()) {
                if (!es.getName().equals(actionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public FunctionImport getFunctionImport(FullQualifiedName fqn, String functionImportName) throws ODataException {
        EntityContainer ec = this.edmSchema.getEntityContainer();
        if (ec.getFunctionImports() != null) {
            for (FunctionImport es : ec.getFunctionImports()) {
                if (!es.getName().equals(functionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public EntityContainerInfo getEntityContainerInfo(FullQualifiedName fqn) throws ODataException {
        EntityContainerInfo info = new EntityContainerInfo();
        info.setContainerName(new FullQualifiedName(this.edmSchema.getNamespace(), this.edmSchema.getNamespace()));
        return info;
    }

    public List<AliasInfo> getAliasInfos() throws ODataException {
        return super.getAliasInfos();
    }

    public EntityContainer getEntityContainer() throws ODataException {
        return this.edmSchema.getEntityContainer();
    }

    public List<Schema> getSchemas() throws ODataException {
        return Arrays.asList(this.edmSchema);
    }

    public EntityType getEntityType(FullQualifiedName fqn) throws ODataException {
        if (this.edmSchema.getEntityTypes() != null) {
            for (EntityType type : this.edmSchema.getEntityTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName fqn) throws ODataException {
        if (this.edmSchema.getComplexTypes() != null) {
            for (ComplexType type : this.edmSchema.getComplexTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public List<Action> getActions(FullQualifiedName fqn) throws ODataException {
        return this.edmSchema.getActions();
    }
}

