/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.EntitySetProcessor;
import org.apache.olingo.server.api.processor.PropertyProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.teiid.core.TeiidException;
import org.teiid.olingo.Client;
import org.teiid.olingo.ContextURLHelper;
import org.teiid.olingo.CountResponse;
import org.teiid.olingo.EntityList;
import org.teiid.olingo.ODataSQLBuilder;
import org.teiid.olingo.SQLParam;
import org.teiid.query.sql.lang.Query;

public class TeiidProcessor
extends DefaultProcessor
implements EntitySetProcessor,
EntityProcessor,
PropertyProcessor {
    private final Client client;
    private final boolean prepared;
    private OData odata;
    private Edm edm;

    public TeiidProcessor(Client client, boolean prepared) {
        this.client = client;
        this.prepared = prepared;
    }

    public void init(OData odata, Edm edm) {
        super.init(odata, edm);
        this.odata = odata;
        this.edm = edm;
    }

    public void readEntitySet(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType format) {
        this.readEntitySet(response, uriInfo, format, false);
    }

    private void readEntitySet(ODataResponse response, UriInfo uriInfo, ContentType contentType, boolean singleRow) {
        try {
            this.checkExpand(uriInfo.asUriInfoResource());
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), this.prepared);
            visitor.visit(uriInfo);
            Query query = visitor.selectQuery(false);
            List<SQLParam> parameters = visitor.getParameters();
            EntityList result = new EntityList(this.client.getProperty("invalid-xml10-character-replacement"), visitor.getEntitySet(), visitor.getProjectedColumns());
            this.client.executeSQL(query, parameters, visitor.isCountQuery(), visitor.getSkip(), visitor.getTop(), result);
            if (singleRow && result.getEntities().isEmpty()) {
                response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            } else {
                ODataFormat format = ODataFormat.fromContentType((ContentType)contentType);
                ODataSerializer serializer = this.odata.createSerializer(format);
                ODataSerializerOptions options = this.getContextUrl(visitor.getEntitySet(), uriInfo, format, serializer, singleRow, new ContextURLHelper().buildURL(uriInfo));
                response.setContent(serializer.entitySet(visitor.getEntitySet(), (EntitySet)result, options));
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                response.setHeader("Content-Type", contentType.toContentTypeString());
            }
        }
        catch (Exception e) {
            this.handleException(response, contentType, e);
        }
    }

    private void handleException(ODataResponse response, ContentType format, Exception e) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)format));
            ODataServerError error = new ODataServerError();
            error.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            if (e instanceof TeiidException) {
                error.setCode(((TeiidException)((Object)e)).getCode());
            }
            error.setException(e);
            serializer.error(error);
        }
        catch (SerializerException e1) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private void checkExpand(UriInfoResource queryInfo) {
        if (queryInfo.getExpandOption() != null && !queryInfo.getExpandOption().getExpandItems().isEmpty()) {
            throw new UnsupportedOperationException("Expand is not supported");
        }
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType format) {
        this.readEntitySet(response, uriInfo, format, true);
    }

    private ODataSerializerOptions getContextUrl(EdmEntitySet entitySet, UriInfo uriInfo, ODataFormat format, ODataSerializer serializer, boolean isSingleEntity, String path) throws SerializerException {
        ContextURL contextUrl = ContextURL.with().entitySetOrSingletonOrType(path).selectList(serializer.buildContextURLSelectList(entitySet, uriInfo.getExpandOption(), uriInfo.getSelectOption())).suffix((ContextURL.Suffix)(isSingleEntity ? ContextURL.Suffix.ENTITY : null)).build();
        return ODataSerializerOptions.with().contextURL(format == ODataFormat.JSON_NO_METADATA ? null : contextUrl).count(uriInfo.getCountOption()).expand(uriInfo.getExpandOption()).select(uriInfo.getSelectOption()).build();
    }

    public void countEntitySet(ODataRequest request, ODataResponse response, UriInfo uriInfo) {
        try {
            this.checkExpand(uriInfo.asUriInfoResource());
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), this.prepared);
            visitor.visit(uriInfo);
            Query query = visitor.selectQuery(true);
            List<SQLParam> parameters = visitor.getParameters();
            CountResponse countResponse = this.client.executeCount(query, parameters);
            ByteArrayInputStream bis = new ByteArrayInputStream(String.valueOf(countResponse.getCount()).getBytes());
            response.setContent((InputStream)bis);
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", ContentType.TEXT_PLAIN.toContentTypeString());
        }
        catch (Exception e) {
            this.handleException(response, ContentType.APPLICATION_JSON, e);
        }
    }

    public void readProperty(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType contentType) {
        try {
            this.checkExpand(uriInfo.asUriInfoResource());
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), this.prepared);
            visitor.visit(uriInfo);
            Query query = visitor.selectQuery(false);
            List<SQLParam> parameters = visitor.getParameters();
            EntityList result = new EntityList(this.client.getProperty("invalid-xml10-character-replacement"), visitor.getEntitySet(), visitor.getProjectedColumns());
            this.client.executeSQL(query, parameters, visitor.isCountQuery(), visitor.getSkip(), visitor.getTop(), result);
            if (result.getEntities().isEmpty()) {
                response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
            } else {
                UriResourceProperty uriProperty = (UriResourceProperty)uriInfo.getUriResourceParts().get(uriInfo.getUriResourceParts().size() - 1);
                EdmProperty edmProperty = uriProperty.getProperty();
                Property property = ((Entity)result.getEntities().get(0)).getProperty(edmProperty.getName());
                if (property == null) {
                    response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
                } else if (property.isNull()) {
                    response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
                } else {
                    ODataFormat format = ODataFormat.fromContentType((ContentType)contentType);
                    ODataSerializer serializer = this.odata.createSerializer(format);
                    ODataSerializerOptions options = this.getContextUrl(visitor.getEntitySet(), uriInfo, format, serializer, false, new ContextURLHelper().buildURL(uriInfo));
                    response.setContent(serializer.entityProperty(edmProperty, property, options));
                    response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                    response.setHeader("Content-Type", contentType.toContentTypeString());
                }
            }
        }
        catch (Exception e) {
            this.handleException(response, contentType, e);
        }
    }

    public void readPropertyValue(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType contentType) {
        block8: {
            try {
                this.checkExpand(uriInfo.asUriInfoResource());
                ODataSQLBuilder visitor = new ODataSQLBuilder(this.client.getMetadataStore(), this.prepared);
                visitor.visit(uriInfo);
                Query query = visitor.selectQuery(false);
                List<SQLParam> parameters = visitor.getParameters();
                EntityList result = new EntityList(this.client.getProperty("invalid-xml10-character-replacement"), visitor.getEntitySet(), visitor.getProjectedColumns());
                this.client.executeSQL(query, parameters, visitor.isCountQuery(), visitor.getSkip(), visitor.getTop(), result);
                if (result.getEntities().isEmpty()) {
                    response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
                    break block8;
                }
                UriResourceProperty uriProperty = (UriResourceProperty)uriInfo.getUriResourceParts().get(uriInfo.getUriResourceParts().size() - 2);
                EdmProperty edmProperty = uriProperty.getProperty();
                Property property = ((Entity)result.getEntities().get(0)).getProperty(edmProperty.getName());
                if (property == null) {
                    response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
                    break block8;
                }
                if (property.isNull()) {
                    response.setStatusCode(HttpStatusCode.NO_CONTENT.getStatusCode());
                    break block8;
                }
                EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
                try {
                    String value = type.valueToString(property.getValue(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode());
                    response.setContent((InputStream)new ByteArrayInputStream(value.getBytes("UTF-8")));
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new ODataApplicationException("Error in value formatting.", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT, (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ODataApplicationException("Encoding exception.", HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.ROOT, (Throwable)e);
                }
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                response.setHeader("Content-Type", ContentType.TEXT_PLAIN.toContentTypeString());
            }
            catch (Exception e) {
                this.handleException(response, contentType, e);
            }
        }
    }
}

