/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.data.AnnotationImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.core.serialization.JsonEntityDeserializer;

public class JsonEntitySetDeserializer
extends JsonDeserializer {
    public JsonEntitySetDeserializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected ResWrap<EntitySet> doDeserialize(JsonParser parser) throws IOException {
        String metadataETag;
        URI contextURL;
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        if (!tree.has("value")) {
            return null;
        }
        EntitySetImpl entitySet = new EntitySetImpl();
        if (tree.hasNonNull("@odata.context")) {
            contextURL = URI.create(tree.get("@odata.context").textValue());
            tree.remove("@odata.context");
        } else if (tree.hasNonNull("odata.metadata")) {
            contextURL = URI.create(tree.get("odata.metadata").textValue());
            tree.remove("odata.metadata");
        } else {
            contextURL = null;
        }
        if (contextURL != null) {
            entitySet.setBaseURI(StringUtils.substringBefore((String)contextURL.toASCIIString(), (String)"$metadata"));
        }
        if (tree.hasNonNull("@odata.metadataEtag")) {
            metadataETag = tree.get("@odata.metadataEtag").textValue();
            tree.remove("@odata.metadataEtag");
        } else {
            metadataETag = null;
        }
        if (tree.hasNonNull(this.jsonCount)) {
            entitySet.setCount(tree.get(this.jsonCount).asInt());
            tree.remove(this.jsonCount);
        }
        if (tree.hasNonNull(this.jsonNextLink)) {
            entitySet.setNext(URI.create(tree.get(this.jsonNextLink).textValue()));
            tree.remove(this.jsonNextLink);
        }
        if (tree.hasNonNull(this.jsonDeltaLink)) {
            entitySet.setDeltaLink(URI.create(tree.get(this.jsonDeltaLink).textValue()));
            tree.remove(this.jsonDeltaLink);
        }
        if (tree.hasNonNull("value")) {
            JsonEntityDeserializer entityDeserializer = new JsonEntityDeserializer(this.version, this.serverMode);
            for (JsonNode jsonNode : tree.get("value")) {
                entitySet.getEntities().add((Entity)entityDeserializer.doDeserialize(jsonNode.traverse(parser.getCodec())).getPayload());
            }
            tree.remove("value");
        }
        Iterator itor = tree.fields();
        while (itor.hasNext()) {
            Map.Entry field = (Map.Entry)itor.next();
            if (((String)field.getKey()).charAt(0) != '@') continue;
            AnnotationImpl annotation = new AnnotationImpl();
            annotation.setTerm(((String)field.getKey()).substring(1));
            try {
                this.value(annotation, (JsonNode)field.getValue(), parser.getCodec());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new IOException(e);
            }
            entitySet.getAnnotations().add(annotation);
        }
        return new ResWrap(contextURL, metadataETag, (Object)entitySet);
    }
}

