/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.serialization.JsonSerializer;

public class JsonPropertySerializer
extends JsonSerializer {
    public JsonPropertySerializer(ODataServiceVersion version, boolean serverMode) {
        super(version, serverMode);
    }

    protected void doSerialize(Property property, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize((ResWrap<Property>)new ResWrap((URI)null, null, (Object)property), jgen);
    }

    protected void doContainerSerialize(ResWrap<Property> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        Property property = (Property)container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode && container.getContextURL() != null) {
            jgen.writeStringField(this.version.compareTo((Enum)ODataServiceVersion.V40) >= 0 ? "@odata.context" : "odata.metadata", container.getContextURL().toASCIIString());
        }
        if (StringUtils.isNotBlank((CharSequence)property.getType())) {
            jgen.writeStringField(this.version.getJsonName(ODataServiceVersion.JsonKey.TYPE), new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build().external(this.version));
        }
        for (Annotation annotation : property.getAnnotations()) {
            this.valuable(jgen, (Valuable)annotation, "@" + annotation.getTerm());
        }
        if (property.isNull()) {
            jgen.writeBooleanField("odata.null", true);
        } else if (property.isPrimitive()) {
            EdmTypeInfo typeInfo = property.getType() == null ? null : new EdmTypeInfo.Builder().setTypeExpression(property.getType()).build();
            jgen.writeFieldName("value");
            this.primitiveValue(jgen, typeInfo, property.asPrimitive());
        } else if (property.isEnum()) {
            jgen.writeStringField("value", property.asEnum().toString());
        } else if (property.isGeospatial() || property.isCollection()) {
            this.valuable(jgen, (Valuable)property, "value");
        } else if (property.isLinkedComplex()) {
            for (Property cproperty : property.asLinkedComplex().getValue()) {
                this.valuable(jgen, (Valuable)cproperty, cproperty.getName());
            }
        } else if (property.isComplex()) {
            for (Property cproperty : property.asComplex()) {
                this.valuable(jgen, (Valuable)cproperty, cproperty.getName());
            }
        }
        jgen.writeEndObject();
    }
}

