/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.util.List;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.teiid.olingo.DefaultODataResourceURLHierarchyVisitor;

public class ContextURLHelper
extends DefaultODataResourceURLHierarchyVisitor {
    private String entitySet;
    private String navPath;
    private boolean singleEntity;

    public String buildURL(UriInfo info) {
        this.visit(info);
        StringBuilder sb = new StringBuilder();
        sb.append(this.entitySet);
        if (!this.singleEntity && this.navPath != null) {
            sb.append(this.navPath);
        }
        return sb.toString();
    }

    @Override
    public void visit(UriResourceEntitySet info) {
        this.entitySet = info.getEntitySet().getName();
        if (info.getKeyPredicates() != null && info.getKeyPredicates().size() > 0) {
            this.navPath = this.buildEntityKey(info.getKeyPredicates());
            this.singleEntity = true;
        }
    }

    private String buildEntityKey(List<UriParameter> keys) {
        if (keys.size() == 1) {
            UriParameter key = keys.get(0);
            Literal literal = (Literal)key.getExpression();
            return "(" + literal.getText() + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < keys.size(); ++i) {
            UriParameter key = keys.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(key.getName());
            sb.append("=");
            Literal literal = (Literal)key.getExpression();
            sb.append(literal.getText());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void visit(UriResourceNavigation info) {
        EdmNavigationProperty property = info.getProperty();
        String navigationName = property.getName();
        this.entitySet = this.entitySet + this.navPath + "/" + navigationName;
        this.navPath = null;
        this.singleEntity = false;
        List keys = info.getKeyPredicates();
        if (keys != null && keys.size() > 0) {
            this.navPath = this.buildEntityKey(keys);
            this.singleEntity = true;
        }
    }

    @Override
    public void visit(UriResourceSingleton info) {
        this.entitySet = info.getSingleton().getName();
    }

    @Override
    public void visit(UriResourcePrimitiveProperty info) {
        if (info.isCollection()) {
            this.entitySet = "Collection(" + info.getProperty().getType().toString() + ")";
        }
        this.entitySet = info.getProperty().getType().toString();
        this.navPath = null;
    }
}

