/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.processor.Processor;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.olingo.Client;
import org.teiid.olingo.OData4EntitySchemaBuilder;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.TeiidEdmProvider;
import org.teiid.olingo.TeiidProcessor;

public class ODataServlet
extends HttpServlet {
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Client client = (Client)request.getAttribute(Client.class.getName());
        String schemaName = (String)request.getAttribute("schema-name");
        org.teiid.metadata.Schema teiidSchema = client.getMetadataStore().getSchema(schemaName);
        if (teiidSchema == null || !ODataServlet.isVisible(client.getVDB(), teiidSchema)) {
            throw new TeiidRuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16022, new Object[0]));
        }
        OData odata = OData.newInstance();
        Schema schema = OData4EntitySchemaBuilder.buildMetadata(teiidSchema);
        Edm edm = odata.createEdm((EdmProvider)new TeiidEdmProvider(client.getMetadataStore(), schema));
        ODataHttpHandler handler = odata.createHandler(edm);
        boolean prepared = true;
        if (request.getParameter("prepared") != null) {
            prepared = Boolean.getBoolean(request.getParameter("prepared"));
        }
        handler.register((Processor)new TeiidProcessor(client, prepared));
        handler.process(request, response);
    }

    private static boolean isVisible(VDBMetaData vdb, org.teiid.metadata.Schema schema) {
        String schemaName = schema.getName();
        ModelMetaData model = vdb.getModel(schemaName);
        if (model == null) {
            return true;
        }
        return model.isVisible();
    }
}

