/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.processor.DefaultProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.EntitySetProcessor;
import org.apache.olingo.server.api.processor.ExceptionProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.processor.PropertyProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.DefaultRedirectProcessor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.RedirectProcessor;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.apache.olingo.server.core.uri.validator.UriValidator;

public class ODataHandler {
    private final OData odata;
    private final Edm edm;
    private final Map<Class<? extends Processor>, Processor> processors = new HashMap<Class<? extends Processor>, Processor>();
    private ContentType requestedContentType;

    public ODataHandler(OData server, Edm edm) {
        this.odata = server;
        this.edm = edm;
        this.register((Processor)new DefaultProcessor());
        this.register(new DefaultRedirectProcessor());
    }

    public ODataResponse process(ODataRequest request) {
        ODataResponse response = new ODataResponse();
        try {
            this.processInternal(request, response);
        }
        catch (UriValidationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserSemanticException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserSyntaxException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (UriParserException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (ContentNegotiatorException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, null);
        }
        catch (SerializerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, this.requestedContentType);
        }
        catch (ODataHandlerException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e, null);
            this.handleException(request, response, serverError, this.requestedContentType);
        }
        catch (ODataApplicationException e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, this.requestedContentType);
        }
        catch (Exception e) {
            ODataServerError serverError = ODataExceptionHelper.createServerErrorObject(e);
            this.handleException(request, response, serverError, this.requestedContentType);
        }
        return response;
    }

    private void processInternal(ODataRequest request, ODataResponse response) throws ODataHandlerException, UriParserException, UriValidationException, ContentNegotiatorException, ODataApplicationException, SerializerException {
        this.validateODataVersion(request, response);
        Parser parser = new Parser();
        UriInfo uriInfo = parser.parseUri(request.getRawODataPath(), request.getRawQueryPath(), null, this.edm);
        UriValidator validator = new UriValidator();
        validator.validate(uriInfo, request.getMethod());
        switch (uriInfo.getKind()) {
            case metadata: {
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    MetadataProcessor mp = this.selectProcessor(MetadataProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)mp, MetadataProcessor.class);
                    mp.readMetadata(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("HttpMethod " + request.getMethod() + " not allowed for metadata document", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, request.getMethod().toString());
            }
            case service: {
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    if ("".equals(request.getRawODataPath())) {
                        RedirectProcessor rdp = this.selectProcessor(RedirectProcessor.class);
                        rdp.redirect(request, response);
                        break;
                    }
                    ServiceDocumentProcessor sdp = this.selectProcessor(ServiceDocumentProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)sdp, ServiceDocumentProcessor.class);
                    sdp.readServiceDocument(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("HttpMethod " + request.getMethod() + " not allowed for service document", ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, request.getMethod().toString());
            }
            case resource: {
                this.handleResourceDispatching(request, response, uriInfo);
                break;
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    public void handleException(ODataRequest request, ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        ExceptionProcessor exceptionProcessor;
        try {
            exceptionProcessor = this.selectProcessor(ExceptionProcessor.class);
        }
        catch (ODataTranslatedException e) {
            exceptionProcessor = new DefaultProcessor();
        }
        if (requestedContentType == null) {
            requestedContentType = ODataFormat.JSON.getContentType(ODataServiceVersion.V40);
        }
        exceptionProcessor.processException(request, response, serverError, requestedContentType);
    }

    private void handleResourceDispatching(ODataRequest request, ODataResponse response, UriInfo uriInfo) throws ODataHandlerException, ContentNegotiatorException, ODataApplicationException, SerializerException {
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case entitySet: {
                if (((UriResourcePartTyped)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntitySetProcessor cp = this.selectProcessor(EntitySetProcessor.class);
                        this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)cp, EntitySetProcessor.class);
                        cp.readEntitySet(request, response, uriInfo, this.requestedContentType);
                        break;
                    }
                    throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = this.selectProcessor(EntityProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case navigationProperty: {
                if (((UriResourceNavigation)lastPathSegment).isCollection()) {
                    if (request.getMethod().equals((Object)HttpMethod.GET)) {
                        EntitySetProcessor cp = this.selectProcessor(EntitySetProcessor.class);
                        this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)cp, EntitySetProcessor.class);
                        cp.readEntitySet(request, response, uriInfo, this.requestedContentType);
                        break;
                    }
                    throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
                }
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntityProcessor ep = this.selectProcessor(EntityProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, EntityProcessor.class);
                    ep.readEntity(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case count: {
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    EntitySetProcessor cp = this.selectProcessor(EntitySetProcessor.class);
                    cp.countEntitySet(request, response, uriInfo);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case primitiveProperty: 
            case complexProperty: {
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    PropertyProcessor ep = this.selectProcessor(PropertyProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, PropertyProcessor.class);
                    ep.readProperty(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            case value: {
                if (request.getMethod().equals((Object)HttpMethod.GET)) {
                    PropertyProcessor ep = this.selectProcessor(PropertyProcessor.class);
                    this.requestedContentType = ContentNegotiator.doContentNegotiation(uriInfo.getFormatOption(), request, (Processor)ep, PropertyProcessor.class);
                    ep.readPropertyValue(request, response, uriInfo, this.requestedContentType);
                    break;
                }
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
            default: {
                throw new ODataHandlerException("not implemented", ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    private void validateODataVersion(ODataRequest request, ODataResponse response) throws ODataHandlerException {
        String maxVersion = request.getHeader("OData-MaxVersion");
        response.setHeader("OData-Version", ODataServiceVersion.V40.toString());
        if (maxVersion != null && ODataServiceVersion.isBiggerThan((String)ODataServiceVersion.V40.toString(), (String)maxVersion)) {
            throw new ODataHandlerException("ODataVersion not supported: " + maxVersion, ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED, maxVersion);
        }
    }

    private <T extends Processor> T selectProcessor(Class<T> cls) throws ODataHandlerException {
        Processor p = this.processors.get(cls);
        if (p == null) {
            throw new ODataHandlerException("Processor: " + cls.getName() + " not registered.", ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED, cls.getName());
        }
        return (T)p;
    }

    public void register(Processor processor) {
        processor.init(this.odata, this.edm);
        for (Class<?> cls : processor.getClass().getInterfaces()) {
            if (!Processor.class.isAssignableFrom(cls) || cls == Processor.class) continue;
            Class<?> procClass = cls;
            this.processors.put(procClass, processor);
        }
    }
}

