/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ODataHttpHandlerImpl;
import org.apache.olingo.server.core.edm.provider.EdmProviderImpl;
import org.apache.olingo.server.core.serializer.ODataXmlSerializerImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;

public class ODataImpl
extends OData {
    public ODataSerializer createSerializer(ODataFormat format) throws SerializerException {
        Object serializer;
        switch (format) {
            case JSON: 
            case JSON_NO_METADATA: 
            case JSON_FULL_METADATA: {
                serializer = new ODataJsonSerializer(format);
                break;
            }
            case XML: {
                serializer = new ODataXmlSerializerImpl();
                break;
            }
            default: {
                throw new SerializerException("Unsupported format: " + format, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{format.toString()});
            }
        }
        return serializer;
    }

    public ODataHttpHandler createHandler(Edm edm) {
        return new ODataHttpHandlerImpl(this, edm);
    }

    public Edm createEdm(EdmProvider edmProvider) {
        return new EdmProviderImpl(edmProvider);
    }
}

