/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmEntityType;
import org.apache.olingo.commons.core.edm.EdmStructuredTypeHelper;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.PropertyRef;
import org.apache.olingo.server.api.edm.provider.StructuredType;
import org.apache.olingo.server.core.edm.provider.EdmKeyPropertyRefImpl;
import org.apache.olingo.server.core.edm.provider.EdmStructuredTypeHelperImpl;

public class EdmEntityTypeImpl
extends AbstractEdmEntityType {
    private final EdmStructuredTypeHelper helper;
    private EntityType entityType;
    private boolean baseTypeChecked = false;

    public static EdmEntityTypeImpl getInstance(Edm edm, FullQualifiedName name, EntityType entityType) {
        EdmEntityTypeImpl instance = new EdmEntityTypeImpl(edm, name, entityType);
        return instance;
    }

    private EdmEntityTypeImpl(Edm edm, FullQualifiedName name, EntityType entityType) {
        super(edm, name, entityType.getBaseType(), entityType.hasStream());
        this.entityType = entityType;
        this.helper = new EdmStructuredTypeHelperImpl(edm, name, (StructuredType)entityType);
    }

    protected Map<String, EdmProperty> getProperties() {
        return this.helper.getProperties();
    }

    protected Map<String, EdmNavigationProperty> getNavigationProperties() {
        return this.helper.getNavigationProperties();
    }

    protected void checkBaseType() {
        if (!this.baseTypeChecked) {
            if (this.baseTypeName != null) {
                this.baseType = this.buildBaseType(this.baseTypeName);
            }
            if (this.baseType == null) {
                this.entityBaseType = null;
                List key = this.entityType.getKey();
                if (key != null) {
                    ArrayList<EdmKeyPropertyRefImpl> edmKey = new ArrayList<EdmKeyPropertyRefImpl>();
                    for (PropertyRef ref : key) {
                        edmKey.add(new EdmKeyPropertyRefImpl((EdmEntityType)this, ref));
                    }
                    this.setEdmKeyPropertyRef(edmKey);
                }
            } else {
                this.entityBaseType = (EdmEntityType)this.baseType;
            }
            this.baseTypeChecked = true;
        }
    }

    public boolean isOpenType() {
        return this.helper.isOpenType();
    }

    public boolean isAbstract() {
        return this.helper.isAbstract();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

