/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.AbstractEdmOperation;
import org.apache.olingo.server.api.edm.provider.EntitySetPath;
import org.apache.olingo.server.api.edm.provider.Operation;
import org.apache.olingo.server.api.edm.provider.Parameter;
import org.apache.olingo.server.core.edm.provider.EdmParameterImpl;
import org.apache.olingo.server.core.edm.provider.EdmReturnTypeImpl;

public abstract class EdmOperationImpl
extends AbstractEdmOperation {
    protected final Operation operation;

    protected static <T extends EdmOperationImpl> T getInstance(T instance) {
        EntitySetPath entitySetPath;
        List providerParameters = instance.operation.getParameters();
        if (providerParameters != null) {
            ArrayList<EdmParameterImpl> _parameters = new ArrayList<EdmParameterImpl>(providerParameters.size());
            for (Parameter parameter : providerParameters) {
                _parameters.add(new EdmParameterImpl(instance.edm, parameter));
            }
            instance.setParameters(_parameters);
        }
        if ((entitySetPath = instance.operation.getEntitySetPath()) != null && entitySetPath.getPath() != null) {
            instance.setEntitySetPath(entitySetPath.getPath());
        }
        instance.setIsBound(instance.operation.isBound());
        if (instance.operation.getReturnType() != null) {
            instance.setReturnType((EdmReturnType)new EdmReturnTypeImpl(instance.edm, instance.operation.getReturnType()));
        }
        return instance;
    }

    protected EdmOperationImpl(Edm edm, FullQualifiedName name, Operation operation, EdmTypeKind kind) {
        super(edm, name, kind);
        this.operation = operation;
    }

    public FullQualifiedName getBindingParameterTypeFqn() {
        if (this.isBound()) {
            Parameter bindingParameter = (Parameter)this.operation.getParameters().get(0);
            return bindingParameter.getType();
        }
        return null;
    }

    public Boolean isBindingParameterTypeCollection() {
        if (this.isBound()) {
            Parameter bindingParameter = (Parameter)this.operation.getParameters().get(0);
            return bindingParameter.isCollection();
        }
        return null;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

