/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.domain;

import java.net.URI;
import org.apache.olingo.commons.api.domain.ODataInlineEntity;
import org.apache.olingo.commons.api.domain.ODataInlineEntitySet;
import org.apache.olingo.commons.api.domain.ODataItem;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class ODataLink
extends ODataItem {
    protected final ODataLinkType type;
    protected final String rel;
    protected String mediaETag;

    private static URI getURI(URI base, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Null link provided");
        }
        URI uri = URI.create(href);
        if (!uri.isAbsolute() && base != null) {
            uri = URI.create(base.toASCIIString() + "/" + href);
        }
        return uri.normalize();
    }

    protected ODataLink(ODataServiceVersion version, URI uri, ODataLinkType type, String title) {
        super(title);
        this.link = uri;
        this.type = type;
        switch (this.type) {
            case ASSOCIATION: {
                this.rel = version.getNamespace(ODataServiceVersion.NamespaceKey.ASSOCIATION_LINK_REL) + title;
                break;
            }
            case ENTITY_NAVIGATION: 
            case ENTITY_SET_NAVIGATION: {
                this.rel = version.getNamespace(ODataServiceVersion.NamespaceKey.NAVIGATION_LINK_REL) + title;
                break;
            }
            default: {
                this.rel = version.getNamespace(ODataServiceVersion.NamespaceKey.MEDIA_EDIT_LINK_REL) + title;
            }
        }
    }

    protected ODataLink(ODataServiceVersion version, URI baseURI, String href, ODataLinkType type, String title) {
        this(version, ODataLink.getURI(baseURI, href), type, title);
    }

    public ODataLinkType getType() {
        return this.type;
    }

    public ODataInlineEntity asInlineEntity() {
        return this instanceof ODataInlineEntity ? (ODataInlineEntity)this : null;
    }

    public ODataInlineEntitySet asInlineEntitySet() {
        return this instanceof ODataInlineEntitySet ? (ODataInlineEntitySet)this : null;
    }

    public String getRel() {
        return this.rel;
    }

    public String getMediaETag() {
        return this.mediaETag;
    }

    public static class Builder {
        protected ODataServiceVersion version;
        protected URI uri;
        protected ODataLinkType type;
        protected String title;

        public Builder setVersion(ODataServiceVersion version) {
            this.version = version;
            return this;
        }

        public Builder setURI(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setURI(URI baseURI, String href) {
            this.uri = ODataLink.getURI(baseURI, href);
            return this;
        }

        public Builder setType(ODataLinkType type) {
            this.type = type;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public ODataLink build() {
            return new ODataLink(this.version, this.uri, this.type, this.title);
        }
    }
}

