/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.domain.ODataOperation;
import org.apache.olingo.commons.core.data.AbstractODataObject;

public class EntityImpl
extends AbstractODataObject
implements Entity {
    private String eTag;
    private String type;
    private Link readLink;
    private Link editLink;
    private final List<Link> associationLinks = new ArrayList<Link>();
    private final List<Link> navigationLinks = new ArrayList<Link>();
    private final List<Link> mediaEditLinks = new ArrayList<Link>();
    private final List<ODataOperation> operations = new ArrayList<ODataOperation>();
    private final List<Property> properties = new ArrayList<Property>();
    private URI mediaContentSource;
    private String mediaContentType;
    private String mediaETag;

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Link getSelfLink() {
        return this.readLink;
    }

    public void setSelfLink(Link readLink) {
        this.readLink = readLink;
    }

    public Link getEditLink() {
        return this.editLink;
    }

    public void setEditLink(Link editLink) {
        this.editLink = editLink;
    }

    private Link getOneByTitle(String name, List<Link> links) {
        Link result = null;
        for (Link link : links) {
            if (!name.equals(link.getTitle())) continue;
            result = link;
        }
        return result;
    }

    public Link getAssociationLink(String name) {
        return this.getOneByTitle(name, this.associationLinks);
    }

    public List<Link> getAssociationLinks() {
        return this.associationLinks;
    }

    public Link getNavigationLink(String name) {
        return this.getOneByTitle(name, this.navigationLinks);
    }

    public List<Link> getNavigationLinks() {
        return this.navigationLinks;
    }

    public List<Link> getMediaEditLinks() {
        return this.mediaEditLinks;
    }

    public List<ODataOperation> getOperations() {
        return this.operations;
    }

    public Entity addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Property getProperty(String name) {
        Property result = null;
        for (Property property : this.properties) {
            if (!name.equals(property.getName())) continue;
            result = property;
        }
        return result;
    }

    public String getMediaContentType() {
        return this.mediaContentType;
    }

    public void setMediaContentType(String mediaContentType) {
        this.mediaContentType = mediaContentType;
    }

    public URI getMediaContentSource() {
        return this.mediaContentSource;
    }

    public void setMediaContentSource(URI mediaContentSource) {
        this.mediaContentSource = mediaContentSource;
    }

    public String getMediaETag() {
        return this.mediaETag;
    }

    public void setMediaETag(String eTag) {
        this.mediaETag = eTag;
    }

    public boolean isMediaEntity() {
        return this.mediaContentSource != null;
    }
}

