/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.Iterator;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.Target;
import org.apache.olingo.commons.core.edm.EdmNamedImpl;

public abstract class AbstractEdmBindingTarget
extends EdmNamedImpl
implements EdmBindingTarget {
    protected final EdmEntityContainer container;
    private final FullQualifiedName type;

    public AbstractEdmBindingTarget(Edm edm, EdmEntityContainer container, String name, FullQualifiedName type) {
        super(edm, name);
        this.container = container;
        this.type = type;
    }

    public EdmEntityContainer getEntityContainer() {
        return this.container;
    }

    public EdmEntityType getEntityType() {
        EdmEntityType entityType = this.edm.getEntityType(this.type);
        if (entityType == null) {
            throw new EdmException("Can\u00b4t find entity type: " + this.type + " for entity set or singleton: " + this.getName());
        }
        return entityType;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.container.getFullQualifiedName();
    }

    public String getAnnotationsTargetPath() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EdmBindingTarget getRelatedBindingTarget(String path) {
        EdmEntitySet bindingTarget = null;
        boolean found = false;
        Iterator itor = this.getNavigationPropertyBindings().iterator();
        while (itor.hasNext() && !found) {
            EdmNavigationPropertyBinding binding = (EdmNavigationPropertyBinding)itor.next();
            if (!binding.getPath().equals(path)) continue;
            Target edmTarget = new Target.Builder(binding.getTarget(), this.container).build();
            EdmEntityContainer entityContainer = this.edm.getEntityContainer(edmTarget.getEntityContainer());
            if (entityContainer == null) {
                throw new EdmException("Cannot find entity container with name: " + edmTarget.getEntityContainer());
            }
            try {
                bindingTarget = entityContainer.getEntitySet(edmTarget.getTargetName());
                if (bindingTarget == null) {
                    throw new EdmException("Cannot find EntitySet " + edmTarget.getTargetName());
                }
                found = bindingTarget != null;
            }
            catch (EdmException e) {
                try {
                    bindingTarget = entityContainer.getSingleton(edmTarget.getTargetName());
                    if (bindingTarget == null) {
                        throw new EdmException("Cannot find Singleton " + edmTarget.getTargetName());
                    }
                    found = bindingTarget != null;
                }
                catch (Throwable throwable) {
                    found = bindingTarget != null;
                    throw throwable;
                }
            }
        }
        return bindingTarget;
    }
}

