/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.AbstractEdmStructuredType;

public abstract class AbstractEdmComplexType
extends AbstractEdmStructuredType
implements EdmComplexType {
    public AbstractEdmComplexType(Edm edm, FullQualifiedName typeName, FullQualifiedName baseTypeName) {
        super(edm, typeName, EdmTypeKind.COMPLEX, baseTypeName);
    }

    @Override
    protected EdmStructuredType buildBaseType(FullQualifiedName baseTypeName) {
        EdmComplexType baseType = null;
        if (baseTypeName != null && (baseType = this.edm.getComplexType(baseTypeName)) == null) {
            throw new EdmException("Can't find base type with name: " + baseTypeName + " for complex type: " + this.getName());
        }
        return baseType;
    }

    public EdmComplexType getBaseType() {
        this.checkBaseType();
        return (EdmComplexType)this.baseType;
    }

    @Override
    protected void checkBaseType() {
        if (this.baseTypeName != null && this.baseType == null) {
            this.baseType = this.buildBaseType(this.baseTypeName);
        }
    }

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.ComplexType;
    }
}

