/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;

public abstract class AbstractEdmKeyPropertyRef
implements EdmKeyPropertyRef {
    private final EdmEntityType edmEntityType;
    private EdmProperty property;

    public AbstractEdmKeyPropertyRef(EdmEntityType edmEntityType) {
        this.edmEntityType = edmEntityType;
    }

    public abstract String getKeyPropertyName();

    public abstract String getAlias();

    public abstract String getPath();

    public EdmProperty getProperty() {
        if (this.property == null) {
            if (this.getAlias() == null) {
                this.property = this.edmEntityType.getStructuralProperty(this.getKeyPropertyName());
                if (this.property == null) {
                    throw new EdmException("Invalid key property ref specified. Can\u00b4t find property with name: " + this.getKeyPropertyName());
                }
            } else {
                if (this.getPath() == null || this.getPath().isEmpty()) {
                    throw new EdmException("Alias but no path specified for propertyRef");
                }
                String[] splitPath = this.getPath().split("/");
                EdmEntityType structType = this.edmEntityType;
                for (int i = 0; i < splitPath.length - 1; ++i) {
                    EdmProperty _property = structType.getStructuralProperty(splitPath[i]);
                    if (_property == null) {
                        throw new EdmException("Invalid property ref specified. Can\u00b4t find property with name: " + splitPath[i] + " at type: " + structType.getNamespace() + "." + structType.getName());
                    }
                    structType = (EdmStructuredType)_property.getType();
                }
                this.property = structType.getStructuralProperty(splitPath[splitPath.length - 1]);
                if (this.property == null) {
                    throw new EdmException("Invalid property ref specified. Can\u00b4t find property with name: " + splitPath[splitPath.length - 1] + " at type: " + structType.getNamespace() + "." + structType.getName());
                }
            }
        }
        return this.property;
    }
}

