/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;

public abstract class AbstractEdmOperation
extends EdmTypeImpl
implements EdmOperation {
    private final Map<String, EdmParameter> parameters = new LinkedHashMap<String, EdmParameter>();
    private String entitySetPath;
    private boolean isBound;
    private EdmReturnType returnType;
    private List<String> parameterNames;

    protected AbstractEdmOperation(Edm edm, FullQualifiedName fqn, EdmTypeKind kind) {
        super(edm, fqn, kind);
    }

    protected void setParameters(List<EdmParameter> _parameters) {
        for (EdmParameter parameter : _parameters) {
            this.parameters.put(parameter.getName(), parameter);
        }
    }

    protected void setEntitySetPath(String entitySetPath) {
        this.entitySetPath = entitySetPath;
    }

    protected void setIsBound(boolean isBound) {
        this.isBound = isBound;
    }

    protected void setReturnType(EdmReturnType returnType) {
        this.returnType = returnType;
    }

    public EdmParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList<String>(this.parameters.size());
            for (String parameterName : this.parameters.keySet()) {
                this.parameterNames.add(parameterName);
            }
        }
        return this.parameterNames;
    }

    public EdmEntitySet getReturnedEntitySet(EdmEntitySet bindingParameterEntitySet) {
        EdmEntitySet returnedEntitySet = null;
        if (bindingParameterEntitySet != null && this.entitySetPath != null) {
            EdmBindingTarget relatedBindingTarget = bindingParameterEntitySet.getRelatedBindingTarget(this.entitySetPath);
            if (relatedBindingTarget == null) {
                throw new EdmException("Cannot find entity set with path: " + this.entitySetPath);
            }
            if (relatedBindingTarget instanceof EdmEntitySet) {
                returnedEntitySet = (EdmEntitySet)relatedBindingTarget;
            } else {
                throw new EdmException("BindingTarget with name: " + relatedBindingTarget.getName() + " must be an entity set");
            }
        }
        return returnedEntitySet;
    }

    public EdmReturnType getReturnType() {
        return this.returnType;
    }

    public boolean isBound() {
        return this.isBound;
    }
}

