/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmElementImpl;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public abstract class AbstractEdmParameter
extends EdmElementImpl
implements EdmParameter {
    private final EdmTypeInfo typeInfo;
    private EdmType typeImpl;

    public AbstractEdmParameter(Edm edm, String name, FullQualifiedName paramType) {
        super(edm, name);
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(paramType.toString()).build();
    }

    public EdmType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.typeInfo.getType();
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.typeInfo.getFullQualifiedName());
            }
        }
        return this.typeImpl;
    }

    public abstract EdmMapping getMapping();

    public abstract Boolean isNullable();

    public abstract Integer getMaxLength();

    public abstract Integer getPrecision();

    public abstract Integer getScale();
}

